module PreludeExamples where
import Data.Maybe (catMaybes)

-- head :: [a] -> a
-- length :: [a] -> Int
-- tail :: [a] -> [a]
-- replicate :: Int -> a -> [a]
-- (++) :: [a] -> [a] -> [a] 


-- zip :: [a] -> [b] -> [(a,b)]


-- myZip (1:2:[]) ('A':[])
-- == (1,'A') : myZip (2:[]) []
-- == (1,'A') : []
-- == [(1,'A')]

--myZip :: [a] -> [b] -> [(a,b)]
--myZip l1 l2 = case l1 of
--  [] -> []
--  x:xs -> case l2 of 
--    [] -> []
--    y:ys ->  (x,y) : myZip xs ys


myZip :: [a] -> [b] -> [(a,b)]
myZip l1 l2 = case (l1,l2) of
  (x:xs,y:ys) -> (x,y) : myZip xs ys  
  _ -> []

addToFront :: a -> b -> ([a],[b]) -> ([a],[b])
addToFront a b (as,bs) = (a:as,b:bs)

myUnzip :: [(a,b)] -> ([a],[b])
myUnzip lst = case lst of 
  [] -> ([],[])
  (x,y):xs -> addToFront x y (myUnzip xs)


-- (!!) :: [a] -> Int -> a 
-- for example
-- [1,3,5,7,9] !! 0 = 1
-- [1,3,5,7,9] !! 1 = 3
-- [1,3,5,7,9] !! 4 = 9
-- [1,3,5,7,9] !! 5 

nth :: [a] -> Int -> a 
nth lst ix = case lst of 
  [] -> error "nth of empty list"
  (x:xs)
    | ix == 0 -> x 
    | otherwise -> nth xs (ix-1) 

-- take :: Int -> [a] -> [a] 
-- for example 
-- take 3 "ABCDEFG" == "ABC"

myTake :: Int -> [a] -> [a] 
myTake n lst = case lst of 
   [] -> []
   (x:xs) 
     | n <= 0 -> []
     | otherwise -> x:(myTake (n-1) xs)

-- |
-- myCatMaybes takes a list of Maybe values lst 
-- and returns all values contained inside Just within lst.
--
-- >>> catMaybes [Just 1, Nothing, Just 3]
-- [1,3]
myCatMaybes :: [Maybe a] -> [a]
myCatMaybes lst = case lst of 
  [] -> []
  (Nothing:xs) -> myCatMaybes xs 
  (Just a:xs)  -> a : (myCatMaybes xs)


isPositive :: Int -> Bool
isPositive x = x > 0

type Name = String 
type Age = Int 
type StudentNo = Int 
type CourseCode = String 

data Student = Student Name Age CourseCode StudentNo


type Database = [Student]

--findId :: StudentNo -> Database -> Maybe Student 
--findId studentNo db = undefined





