/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Pair;
import comp1110.universe.Image;
import comp1110.universe.KeyEvent;
import comp1110.universe.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class ComplianceTest {
    public static final String classpath = ".";
    public static final String outputDir = "_compliance";
    TypeVariable artifactType = new TypeVariable("Artifact");
    TypeVariable resultType = new TypeVariable("Result");
    TypeVariable scavengerType = new TypeVariable("Scavenger");
    RequiredFunction rationalScavengerAnalysis = new RequiredFunction("rationalScavengerAnalysis", this.resultType, new TypeAssumption[]{this.artifactType, this.artifactType}, new String[0]);
    RequiredFunction riskTakerScavengerAnalysis = new RequiredFunction("riskTakerScavengerAnalysis", this.resultType, new TypeAssumption[]{this.artifactType, this.artifactType}, new String[0]);
    RequiredFunction isValuable = new RequiredFunction("isValuable", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.resultType}, new String[0]);
    RequiredFunction isHazardous = new RequiredFunction("isHazardous", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.resultType}, new String[0]);
    RequiredFunction isMundane = new RequiredFunction("isMundane", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.resultType}, new String[0]);
    RequiredFunction isIncompatible = new RequiredFunction("isIncompatible", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.resultType}, new String[0]);
    RequiredFunction isUnknown = new RequiredFunction("isUnknown", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.resultType}, new String[0]);
    RequiredFunction makeStarChart = new RequiredFunction("makeStarChart", this.artifactType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0]), new PrimitiveType(Integer.TYPE), new PrimitiveType(Integer.TYPE), new PrimitiveType(Integer.TYPE)}, new String[0]);
    RequiredFunction makeEnergyCrystal = new RequiredFunction("makeEnergyCrystal", this.artifactType, new TypeAssumption[]{new PrimitiveType(Integer.TYPE)}, new String[0]);
    RequiredFunction makeInertRock = new RequiredFunction("makeInertRock", this.artifactType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction exploreAsteroid = new RequiredFunction("exploreAsteroid", new ConcreteType(Pair.class, new TypeAssumption[0]), new TypeAssumption[]{this.scavengerType, this.artifactType}, new String[0]);
    RequiredFunction tradeAtStarport = new RequiredFunction("tradeAtStarport", new ConcreteType(Pair.class, new TypeAssumption[0]), new TypeAssumption[]{this.scavengerType, this.scavengerType}, new String[0]);
    RequiredFunction makeScavenger = new RequiredFunction("makeScavenger", this.scavengerType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0]), new ConcreteType(BiFunction.class, new TypeAssumption[0]), this.artifactType}, new String[0]);
    RequiredFunction getCargo = new RequiredFunction("getCargo", this.artifactType, new TypeAssumption[]{this.scavengerType}, new String[0]);
    RequiredFunction getName = new RequiredFunction("getName", new ConcreteType(String.class, new TypeAssumption[0]), new TypeAssumption[]{this.scavengerType}, new String[0]);
    RequiredFunction describeArtifact = new RequiredFunction("describeArtifact", new ConcreteType(String.class, new TypeAssumption[0]), new TypeAssumption[]{this.artifactType}, new String[0]);
    RequiredFunction parseRationalScavengerLog = new RequiredFunction("parseRationalScavengerLog", this.artifactType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0])}, new String[0]);
    RequiredClass artifactsClass = new RequiredClass("Artifacts", new RequiredFunction[]{this.rationalScavengerAnalysis, this.riskTakerScavengerAnalysis, this.isValuable, this.isHazardous, this.isMundane, this.isIncompatible, this.isUnknown, this.makeStarChart, this.makeEnergyCrystal, this.makeInertRock, this.exploreAsteroid, this.tradeAtStarport, this.makeScavenger, this.getCargo, this.getName, this.describeArtifact, this.parseRationalScavengerLog}, new TypeVariable[]{this.artifactType, this.resultType, this.scavengerType}, new String[0]);
    TypeVariable worldType = new TypeVariable("World");
    TypeVariable directionType = new TypeVariable("Direction");
    TypeVariable marbleType = new TypeVariable("Marble");
    RequiredFunction step = new RequiredFunction("step", this.worldType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction draw = new RequiredFunction("draw", new ConcreteType(Image.class, new TypeAssumption[0]), new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction mouseEvent = new RequiredFunction("mouseEvent", this.worldType, new TypeAssumption[]{this.worldType, new ConcreteType(MouseEvent.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction keyEvent = new RequiredFunction("keyEvent", this.worldType, new TypeAssumption[]{this.worldType, new ConcreteType(KeyEvent.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction getInitialState = new RequiredFunction("getInitialState", this.worldType, new TypeAssumption[0], new String[0]);
    RequiredFunction getMarble1 = new RequiredFunction("getMarble1", this.marbleType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction getMarble2 = new RequiredFunction("getMarble2", this.marbleType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction getMarble3 = new RequiredFunction("getMarble3", this.marbleType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction getMarble4 = new RequiredFunction("getMarble4", this.marbleType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction getX = new RequiredFunction("getX", new PrimitiveType(Integer.TYPE), new TypeAssumption[]{this.marbleType}, new String[0]);
    RequiredFunction getY = new RequiredFunction("getY", new PrimitiveType(Integer.TYPE), new TypeAssumption[]{this.marbleType}, new String[0]);
    RequiredFunction getDirection = new RequiredFunction("getDirection", this.directionType, new TypeAssumption[]{this.marbleType}, new String[0]);
    RequiredFunction isNorth = new RequiredFunction("isNorth", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isSouth = new RequiredFunction("isSouth", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isEast = new RequiredFunction("isEast", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isWest = new RequiredFunction("isWest", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isNorthEast = new RequiredFunction("isNorthEast", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isNorthWest = new RequiredFunction("isNorthWest", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isSouthEast = new RequiredFunction("isSouthEast", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredFunction isSouthWest = new RequiredFunction("isSouthWest", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.directionType}, new String[0]);
    RequiredClass bouncingMarblesClass = new RequiredClass("BouncingMarbles", new RequiredFunction[]{this.step, this.draw, this.mouseEvent, this.keyEvent, this.getInitialState, this.getMarble1, this.getMarble2, this.getMarble3, this.getMarble4, this.getX, this.getY, this.getDirection, this.isNorth, this.isSouth, this.isEast, this.isWest, this.isNorthEast, this.isNorthWest, this.isSouthEast, this.isSouthWest}, new TypeVariable[]{this.worldType, this.directionType, this.marbleType}, new String[0]);

    public static boolean checkFileExists(String string) {
        Path path = Paths.get(string, new String[0]);
        boolean bl = Files.exists(path, new LinkOption[0]);
        if (!bl) {
            System.out.println("\u274c FAILURE: " + string + " not found in the current directory.");
            return false;
        }
        System.out.println("File " + string + " found.");
        return true;
    }

    public static boolean compileFile(String string) {
        new File(outputDir).mkdirs();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            System.err.println("CRITICAL: JDK not found. Cannot find system Java compiler -- Report this to the conveners.");
            return false;
        }
        if (javaCompiler.run(null, null, null, "--enable-preview", "--release", "23", "-d", outputDir, "-cp", classpath, new File(string).getAbsolutePath()) != 0) {
            System.out.println("\u274c FAILURE: Could not compile " + string + ". Please check for syntax errors.");
            return false;
        }
        System.out.println(string + " compiled successfully.");
        return true;
    }

    public static int complianceNotebook() {
        return ComplianceTest.checkFileExists("notebook.yml") ? 0 : 1;
    }

    public static int complianceOriginalityStatement() {
        int n;
        List<String> list;
        List<String> list2 = Arrays.asList("I declare that this work upholds the principles of academic", "integrity, as defined in the University Academic Misconduct", "Rule; is entirely my own work; is produced for the purposes", "of this assessment task and has not been submitted for", "assessment in any other context, except where authorised in", "writing by the course convener; gives appropriate", "acknowledgement of the ideas, scholarship and intellectual", "property of others insofar as these have been used; in no part", "involves copying, cheating, collusion, fabrication, plagiarism", "or recycling.", "", "I declare that I have not used any form of generative AI in", "preparing this work.", "", "I declare that I have the rights to use and submit any assets", "included in this work.", "", "[your name here]", "[your UID here]");
        int n2 = 0;
        if (!ComplianceTest.checkFileExists("soo.txt")) {
            return 1;
        }
        Path path = Paths.get("soo.txt", new String[0]);
        try {
            list = Files.readAllLines(path);
        }
        catch (IOException iOException) {
            System.out.println("\u274c FAILURE: Could not read soo.txt: " + iOException.getMessage());
            return 1;
        }
        int n3 = 0;
        for (n = 0; n3 < list2.size() && n < list.size(); ++n3, ++n) {
            while (n3 < list2.size() && list2.get(n3).trim().isEmpty()) {
                ++n3;
            }
            while (n < list.size() && list.get(n).trim().isEmpty()) {
                ++n;
            }
            if (n3 >= list2.size() || n >= list.size()) break;
            String string = list2.get(n3).trim();
            String string2 = list.get(n).trim();
            if ("[your name here]".equals(string)) {
                if (string2.contains("[") || string2.contains("]")) {
                    System.out.println("\u274c FAILURE: soo.txt bad signature - still contains braces.");
                    ++n2;
                }
                if (!string2.isEmpty()) continue;
                System.out.println("\u274c FAILURE: soo.txt no signature provided.");
                ++n2;
                continue;
            }
            if ("[your UID here]".equals(string)) {
                if (string2.length() != 8) {
                    System.out.println("\u274c FAILURE: UID '" + string2 + "' is not 8 characters long.");
                    ++n2;
                    continue;
                }
                if (string2.toLowerCase().charAt(0) != 'u') {
                    System.out.println("\u274c FAILURE: UID '" + string2 + "' does not start with 'u'.");
                    ++n2;
                }
                if (string2.substring(1).matches("\\d+")) continue;
                System.out.println("\u274c FAILURE: UID '" + string2 + "' does not contain 7 digits after 'u'.");
                ++n2;
                continue;
            }
            if (string.equals(string2)) continue;
            System.out.println("\u274c FAILURE: Mismatch of line '" + string + "' -- found: '" + string2 + "'");
            ++n2;
        }
        while (n3 < list2.size() && list2.get(n3).trim().isEmpty()) {
            ++n3;
        }
        while (n < list.size() && list.get(n).trim().isEmpty()) {
            ++n;
        }
        if (n3 < list2.size() || n < list.size()) {
            System.out.println("\u274c FAILURE: Statement is malformed (incorrect number of non-empty lines).");
            ++n2;
        }
        return n2;
    }

    public static int complianceComp1110Folder() {
        Path path = Paths.get("comp1110", new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.out.println("\u274c FAILURE: folder comp1110 not found in the current folder -- Skipping further tests");
            return 1;
        }
        System.out.println("Found comp1110 folder.");
        return 0;
    }

    private static int runComplianceTest(String string, ComplianceAction complianceAction) {
        if (!ComplianceTest.checkFileExists(string)) {
            System.out.println("  -- Skipping compliance tests on " + string);
            return 1;
        }
        int n = 0;
        if (ComplianceTest.compileFile(string)) {
            System.out.println("Running compliance on " + string);
            try {
                URL uRL = new File(outputDir).getAbsoluteFile().getCanonicalFile().toURI().toURL();
                URL uRL2 = new File(classpath).getAbsoluteFile().getCanonicalFile().toURI().toURL();
                try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL, uRL2}, ClassLoader.getSystemClassLoader());){
                    ComplianceTest complianceTest = new ComplianceTest();
                    n = complianceAction.execute(complianceTest, uRLClassLoader);
                    if (n == 0) {
                        System.out.println("Success! All required records and functions in " + string + " were found.");
                    } else {
                        System.out.println("\u274c FAILURE: " + string + " is missing one or more items. See messages above.");
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Testing framework encountered internal error. See error information below.\n");
                System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage() + "\n");
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            n = 1;
        }
        return n;
    }

    public static int complianceArtifacts() {
        return ComplianceTest.runComplianceTest("Artifacts.java", (complianceTest, uRLClassLoader) -> {
            InterfaceCollector.collect(new RequiredClass[]{complianceTest.artifactsClass}, uRLClassLoader);
            return complianceTest.artifactsClass.checkErrors();
        });
    }

    public static int complianceMarbles() {
        return ComplianceTest.runComplianceTest("BouncingMarbles.java", (complianceTest, uRLClassLoader) -> {
            InterfaceCollector.collect(new RequiredClass[]{complianceTest.bouncingMarblesClass}, uRLClassLoader);
            return complianceTest.bouncingMarblesClass.checkErrors();
        });
    }

    public static void main(String[] stringArray) {
        System.out.println("Compliance checker 1.01. Starting compliance check...");
        int n = 0;
        n += ComplianceTest.complianceNotebook();
        n += ComplianceTest.complianceOriginalityStatement();
        if (ComplianceTest.complianceComp1110Folder() == 0) {
            n += ComplianceTest.complianceArtifacts();
            n += ComplianceTest.complianceMarbles();
        } else {
            ++n;
        }
        if (n == 0) {
            System.out.println("Compliance check finished. No compliance issues found.");
        } else {
            System.out.println("\u274c \u274c \u274c Compliance check finished. Found " + n + " compliance issues. \u274c \u274c \u274c ");
        }
    }

    @FunctionalInterface
    private static interface ComplianceAction {
        public int execute(ComplianceTest var1, URLClassLoader var2);
    }
}

