/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConcreteType
implements TypeAssumption {
    public final Class<?> type;
    public final TypeAssumption[] arguments;
    private final List<Pair<String, Type>> upperBounds = new ArrayList<Pair<String, Type>>();
    private final List<Pair<String, Type>> lowerBounds = new ArrayList<Pair<String, Type>>();

    public ConcreteType(Class<?> clazz, TypeAssumption ... typeAssumptionArray) {
        this.type = clazz;
        this.arguments = typeAssumptionArray;
    }

    @Override
    public boolean addConstraint(String string, Type type, Variance variance) {
        switch (variance) {
            case INVARIANT: {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                break;
            }
            case COVARIANT: {
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                break;
            }
            case CONTRAVARIANT: {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
            }
        }
        return this.matches(type, variance);
    }

    @Override
    public boolean matches(Type type, Variance variance) {
        if (type.equals(this.type)) {
            return true;
        }
        if (variance.equals((Object)Variance.INVARIANT)) {
            return Util.SubtypeOf(this.type, type, new HashMap()) && Util.SubtypeOf(type, this.type, new HashMap());
        }
        if (variance.equals((Object)Variance.COVARIANT)) {
            return Util.SubtypeOf(type, this.type, new HashMap());
        }
        return Util.SubtypeOf(this.type, type, new HashMap());
    }

    @Override
    public int checkErrors() {
        Type type;
        int n = 0;
        for (Pair<String, Type> pair : this.lowerBounds) {
            type = (Type)pair.second();
            if (Util.SubtypeOf(type, this.type, new HashMap())) continue;
            ++n;
            System.out.println("\u274c FAILURE: Expected subtype of " + this.type.getTypeName() + " for " + (String)pair.first() + " but found " + type.getTypeName());
        }
        for (Pair<String, Type> pair : this.upperBounds) {
            type = (Type)pair.second();
            if (Util.SubtypeOf(this.type, type, new HashMap())) continue;
            ++n;
            System.out.println("\u274c FAILURE: Expected supertype of " + this.type.getTypeName() + " for " + (String)pair.first() + " but found " + type.getTypeName());
        }
        return n;
    }

    @Override
    public int checkConstraintErrors() {
        Type type;
        int n = 0;
        for (Pair<String, Type> pair : this.lowerBounds) {
            type = (Type)pair.second();
            if (Util.SubtypeOf(type, this.type, new HashMap())) continue;
            ++n;
            System.out.println("\u274c FAILURE: Expected subtype of " + this.type.getTypeName() + " for " + (String)pair.first() + " but found " + type.getTypeName());
        }
        for (Pair<String, Type> pair : this.upperBounds) {
            type = (Type)pair.second();
            if (Util.SubtypeOf(this.type, type, new HashMap())) continue;
            ++n;
            System.out.println("\u274c FAILURE: Expected supertype of " + this.type.getTypeName() + " for " + (String)pair.first() + " but found " + type.getTypeName());
        }
        return n;
    }

    @Override
    public Type asType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public boolean isValid() {
        for (Pair<String, Type> pair : this.lowerBounds) {
            if (Util.SubtypeOf((Type)pair.second(), this.type, new HashMap())) continue;
            return false;
        }
        for (Pair<String, Type> pair : this.upperBounds) {
            if (Util.SubtypeOf(this.type, (Type)pair.second(), new HashMap())) continue;
            return false;
        }
        return true;
    }
}

