/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Pair;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenericType
implements ParameterizedType,
TypeAssumption {
    public final Class<?> klass;
    public final TypeAssumption[] arguments;
    private List<Pair<String, Type>> upperBounds = new ArrayList<Pair<String, Type>>();
    private List<Pair<String, Type>> lowerBounds = new ArrayList<Pair<String, Type>>();

    public GenericType(Class<?> clazz, TypeAssumption ... typeAssumptionArray) {
        this.klass = clazz;
        this.arguments = typeAssumptionArray;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])Arrays.stream(this.arguments).map(TypeAssumption::asType).toArray(Type[]::new);
    }

    @Override
    public Type getRawType() {
        return this.klass;
    }

    @Override
    public Type getOwnerType() {
        return null;
    }

    @Override
    public String getName() {
        Object object = this.klass.getName();
        if (this.arguments.length > 0) {
            object = (String)object + "<";
            object = (String)object + String.join((CharSequence)", ", Arrays.stream(this.arguments).map(RequiredComponent::getName).toList());
            object = (String)object + ">";
        }
        return object;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public boolean addConstraint(String string, Type type, Variance variance) {
        boolean bl = true;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type type2 = parameterizedType.getRawType();
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            if (type2.equals(this.klass)) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    bl = bl && this.arguments[i].addConstraint(string, typeArray[i], Variance.INVARIANT);
                }
            }
            if (variance.equals((Object)Variance.INVARIANT)) {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type2));
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type2));
            } else if (variance.equals((Object)Variance.COVARIANT)) {
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type2));
            } else {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type2));
            }
        } else {
            if (variance.equals((Object)Variance.INVARIANT)) {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
            } else if (variance.equals((Object)Variance.COVARIANT)) {
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
            } else {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean matches(Type type, Variance variance) {
        return Util.CheckSubtyping(type, this, variance);
    }

    @Override
    public int checkErrors() {
        int n = 0;
        for (Pair<String, Type> pair : this.upperBounds) {
            if (((Type)pair.second()).equals(this.klass)) continue;
            ++n;
            System.out.println("\u274c FAILURE: Invalid type for " + (String)pair.first() + ": expected " + this.klass.getTypeName() + " but got " + ((Type)pair.second()).getTypeName());
        }
        for (Pair<String, Type> pair : this.lowerBounds) {
            if (((Type)pair.second()).equals(this.klass)) continue;
            ++n;
            System.out.println("\u274c FAILURE: Invalid type for " + (String)pair.first() + ": expected " + this.klass.getTypeName() + " but got " + ((Type)pair.second()).getTypeName());
        }
        return n;
    }

    @Override
    public int checkConstraintErrors() {
        int n = 0;
        for (Pair<String, Type> pair : this.upperBounds) {
            if (((Type)pair.second()).equals(this.klass)) continue;
            ++n;
            System.out.println("\u274c FAILURE: Invalid type for " + (String)pair.first() + ": expected " + this.klass.getTypeName() + " but got " + ((Type)pair.second()).getTypeName());
        }
        for (Pair<String, Type> pair : this.lowerBounds) {
            if (((Type)pair.second()).equals(this.klass)) continue;
            ++n;
            System.out.println("\u274c FAILURE: Invalid type for " + (String)pair.first() + ": expected " + this.klass.getTypeName() + " but got " + ((Type)pair.second()).getTypeName());
        }
        return n;
    }

    @Override
    public Type asType() {
        return this;
    }
}

