/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class OrTest
implements Test {
    public final String name;
    public final int maxMarks;
    public final Test[] tests;

    public OrTest(String string, int n, Test ... testArray) {
        this.name = string;
        this.maxMarks = n;
        this.tests = testArray;
    }

    @Override
    public RequiredClass[] getRequiredClasses() {
        ArrayList<RequiredClass> arrayList = new ArrayList<RequiredClass>();
        for (Test test : this.tests) {
            for (RequiredClass requiredClass : test.getRequiredClasses()) {
                if (arrayList.contains(requiredClass)) continue;
                arrayList.add(requiredClass);
            }
        }
        return arrayList.toArray(new RequiredClass[0]);
    }

    @Override
    public RequiredFunction[] getRequiredFunctions() {
        ArrayList<RequiredFunction> arrayList = new ArrayList<RequiredFunction>();
        for (Test test : this.tests) {
            for (RequiredFunction requiredFunction : test.getRequiredFunctions()) {
                if (arrayList.contains(requiredFunction)) continue;
                arrayList.add(requiredFunction);
            }
        }
        return arrayList.toArray(new RequiredFunction[0]);
    }

    @Override
    public TypeVariable[] getTypeVariables() {
        ArrayList<TypeVariable> arrayList = new ArrayList<TypeVariable>();
        for (Test test : this.tests) {
            for (TypeVariable typeVariable : test.getTypeVariables()) {
                if (arrayList.contains(typeVariable)) continue;
                arrayList.add(typeVariable);
            }
        }
        return arrayList.toArray(new TypeVariable[0]);
    }

    @Override
    public RequiredValue[] getRequiredValues() {
        ArrayList<RequiredValue> arrayList = new ArrayList<RequiredValue>();
        for (Test test : this.tests) {
            for (RequiredValue requiredValue : test.getRequiredValues()) {
                if (arrayList.contains(requiredValue)) continue;
                arrayList.add(requiredValue);
            }
        }
        return arrayList.toArray(new RequiredValue[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxMarks() {
        return this.maxMarks;
    }

    @Override
    public int runTest() {
        System.out.println("Test " + this.name + " (OR; " + this.maxMarks + " marks)");
        System.out.println("--------------------------------------");
        int n = 0;
        for (Test test : this.tests) {
            try {
                boolean bl = test.runAsComponent();
                n = bl ? this.maxMarks : n;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("--------------------------------------");
        System.out.println("Result: " + n + "/" + this.maxMarks + " marks");
        System.out.println("--------------------------------------");
        return n;
    }

    @Override
    public boolean runAsComponent() {
        System.out.println("Test " + this.name + " [OR]");
        System.out.println("--------------------------------------");
        for (Test test : this.tests) {
            try {
                boolean bl = test.runAsComponent();
                if (!bl) continue;
                System.out.println("--------------------------------------");
                System.out.println("Result: success!");
                System.out.println("--------------------------------------");
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("--------------------------------------");
        System.out.println("Result: failure!");
        System.out.println("--------------------------------------");
        return false;
    }
}

