/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class PrimitiveType
implements TypeAssumption {
    private final Class<?> primitiveType;
    private final Class<?> wrapperType;
    List<Pair<String, Type>> constraints = new ArrayList<Pair<String, Type>>();

    public PrimitiveType(Class<?> clazz) {
        if (clazz.equals(Boolean.TYPE) || clazz.equals(Boolean.class)) {
            this.primitiveType = Boolean.TYPE;
            this.wrapperType = Boolean.class;
        } else if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            this.primitiveType = Integer.TYPE;
            this.wrapperType = Integer.class;
        } else if (clazz.equals(Short.TYPE) || clazz.equals(Short.class)) {
            this.primitiveType = Short.TYPE;
            this.wrapperType = Short.class;
        } else if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            this.primitiveType = Long.TYPE;
            this.wrapperType = Long.class;
        } else if (clazz.equals(Character.TYPE) || clazz.equals(Character.class)) {
            this.primitiveType = Character.TYPE;
            this.wrapperType = Character.class;
        } else if (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class)) {
            this.primitiveType = Byte.TYPE;
            this.wrapperType = Byte.class;
        } else if (clazz.equals(Double.TYPE) || clazz.equals(Double.class)) {
            this.primitiveType = Double.TYPE;
            this.wrapperType = Double.class;
        } else if (clazz.equals(Float.TYPE) || clazz.equals(Float.class)) {
            this.primitiveType = Float.TYPE;
            this.wrapperType = Float.class;
        } else if (clazz.equals(Void.TYPE) || clazz.equals(Void.class)) {
            this.primitiveType = Void.TYPE;
            this.wrapperType = Void.class;
        } else {
            throw new IllegalArgumentException("not a primitive type: " + clazz.getName());
        }
    }

    @Override
    public boolean addConstraint(String string, Type type, Variance variance) {
        this.constraints.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
        return false;
    }

    @Override
    public boolean matches(Type type, Variance variance) {
        return this.primitiveType.equals(type) || this.wrapperType.equals(type);
    }

    @Override
    public int checkErrors() {
        int n = 0;
        for (Pair<String, Type> pair : this.constraints) {
            Type type = (Type)pair.second();
            if (type.equals(this.primitiveType) || type.equals(this.wrapperType)) continue;
            ++n;
            System.err.println("\u274c FAILURE: Invalid type used for " + (String)pair.first() + " - " + this.primitiveType.getName() + " expected, " + type.getTypeName() + " found");
        }
        return n;
    }

    @Override
    public int checkConstraintErrors() {
        int n = 0;
        for (Pair<String, Type> pair : this.constraints) {
            Type type = (Type)pair.second();
            if (type.equals(this.primitiveType) || type.equals(this.wrapperType)) continue;
            ++n;
            System.err.println("\u274c FAILURE: Invalid type used for " + (String)pair.first() + " - " + this.primitiveType.getName() + " expected, " + type.getTypeName() + " found");
        }
        return n;
    }

    @Override
    public Type asType() {
        return this.wrapperType;
    }

    @Override
    public String getName() {
        return this.primitiveType.getName();
    }

    @Override
    public boolean isValid() {
        for (Pair<String, Type> pair : this.constraints) {
            Type type = (Type)pair.second();
            if (type.equals(this.primitiveType) || type.equals(this.wrapperType)) continue;
            return false;
        }
        return true;
    }
}

