/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class RequiredClass
implements RequiredComponent {
    public final String name;
    public final RequiredFunction[] requiredFunctions;
    public final TypeVariable[] typeVariables;
    public final String[] alternateNames;
    private Class<?> klass;

    public Class<?> getLoadedClass() {
        return this.klass;
    }

    public void registerClass(Class<?> clazz) {
        if (this.klass != null) {
            throw new IllegalStateException("Class already registered");
        }
        this.klass = clazz;
        for (RequiredFunction requiredFunction : this.requiredFunctions) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (requiredFunction.matches(method)) break;
            }
        }
        for (RequiredFunction requiredFunction : this.requiredFunctions) {
            if (requiredFunction.hasMatch()) continue;
            for (Method method : clazz.getDeclaredMethods()) {
                if (requiredFunction.matchesExtended(method)) break;
            }
        }
    }

    public RequiredClass(String string, RequiredFunction[] requiredFunctionArray, TypeVariable[] typeVariableArray, String ... stringArray) {
        this.name = string;
        this.requiredFunctions = requiredFunctionArray;
        this.typeVariables = typeVariableArray;
        this.alternateNames = stringArray;
        for (RequiredFunction requiredFunction : requiredFunctionArray) {
            requiredFunction.registerClass(this);
        }
        if (stringArray.length > 0) {
            throw new RuntimeException("Alternate names not implemented yet");
        }
    }

    public int checkErrors() {
        int n = 0;
        if (this.klass == null) {
            ++n;
            System.err.println("\u274c FAILURE: Main class not found: " + this.name);
        } else {
            for (RequiredFunction requiredComponent : this.requiredFunctions) {
                n += requiredComponent.checkErrors();
            }
            for (RequiredComponent requiredComponent : this.typeVariables) {
                n += ((TypeVariable)requiredComponent).checkErrors();
            }
        }
        return n;
    }

    public Object getInstance() {
        try {
            Constructor<?> constructor = this.klass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.klass != null && this.klass.getDeclaredConstructors().length != 0;
    }
}

