/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public abstract class RequiredValue
implements RequiredComponent {
    public final String name;
    public final RequiredComponent[] requiredComponents;
    private Object value;

    public RequiredValue(String string, RequiredComponent[] requiredComponentArray) {
        this.name = string;
        this.requiredComponents = requiredComponentArray;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.value != null;
    }

    public boolean canCompute() {
        return Arrays.stream(this.requiredComponents).allMatch(RequiredComponent::isValid);
    }

    public Object getValue() {
        return this.value;
    }

    public Object computeValue() {
        System.out.println("Obtaining value: " + this.name);
        System.out.println("--------------------------------------");
        if (!this.canCompute()) {
            System.out.println("Missing required component(s): " + String.join((CharSequence)", ", Arrays.stream(this.requiredComponents).map(RequiredComponent::getName).toList()));
            System.out.println("Could not obtain value: " + this.name);
            System.out.println("--------------------------------------");
            return null;
        }
        try {
            this.value = this.computeValueImpl();
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            System.out.println("Could not obtain value: " + this.name);
            System.out.println("--------------------------------------");
            this.value = null;
            return null;
        }
        System.out.println("Success: " + String.valueOf(this.value));
        System.out.println("--------------------------------------");
        return this.value;
    }

    protected abstract Object computeValueImpl();
}

