/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TestGroup
implements Test {
    public final String name;
    public final Test[] tests;
    public final Map<Integer, Integer> markBoundaries = new HashMap<Integer, Integer>();

    public TestGroup(String string, Test ... testArray) {
        this.name = string;
        this.tests = testArray;
    }

    public TestGroup addMarkBoundary(int n, int n2) {
        this.markBoundaries.put(n, n2);
        return this;
    }

    @Override
    public RequiredClass[] getRequiredClasses() {
        ArrayList<RequiredClass> arrayList = new ArrayList<RequiredClass>();
        for (Test test2 : this.tests) {
            for (RequiredClass requiredClass : test2.getRequiredClasses()) {
                if (arrayList.contains(requiredClass) || !Arrays.stream(this.tests).allMatch(test -> Arrays.asList(test.getRequiredClasses()).contains(requiredClass))) continue;
                arrayList.add(requiredClass);
            }
        }
        return arrayList.toArray(new RequiredClass[0]);
    }

    @Override
    public RequiredFunction[] getRequiredFunctions() {
        ArrayList<RequiredFunction> arrayList = new ArrayList<RequiredFunction>();
        for (Test test2 : this.tests) {
            for (RequiredFunction requiredFunction : test2.getRequiredFunctions()) {
                if (arrayList.contains(requiredFunction) || !Arrays.stream(this.tests).allMatch(test -> Arrays.asList(test.getRequiredFunctions()).contains(requiredFunction))) continue;
                arrayList.add(requiredFunction);
            }
        }
        return arrayList.toArray(new RequiredFunction[0]);
    }

    @Override
    public TypeVariable[] getTypeVariables() {
        ArrayList<TypeVariable> arrayList = new ArrayList<TypeVariable>();
        for (Test test2 : this.tests) {
            for (TypeVariable typeVariable : test2.getTypeVariables()) {
                if (arrayList.contains(typeVariable) || !Arrays.stream(this.tests).allMatch(test -> Arrays.asList(test.getTypeVariables()).contains(typeVariable))) continue;
                arrayList.add(typeVariable);
            }
        }
        return arrayList.toArray(new TypeVariable[0]);
    }

    @Override
    public RequiredValue[] getRequiredValues() {
        ArrayList<RequiredValue> arrayList = new ArrayList<RequiredValue>();
        for (Test test2 : this.tests) {
            for (RequiredValue requiredValue : test2.getRequiredValues()) {
                if (arrayList.contains(requiredValue) || !Arrays.stream(this.tests).allMatch(test -> Arrays.asList(test.getRequiredValues()).contains(requiredValue))) continue;
                arrayList.add(requiredValue);
            }
        }
        return arrayList.toArray(new RequiredValue[0]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxMarks() {
        return this.markBoundaries.values().stream().max(Integer::compareTo).get();
    }

    @Override
    public int runTest() {
        System.out.println("Test Group " + this.name + " (" + this.getMaxMarks() + " marks)");
        System.out.println("--------------------------------------");
        if (!this.canRun()) {
            System.out.println("Cannot run. Missing components: " + String.join((CharSequence)", ", this.missingComponents()));
            System.out.println("--------------------------------------");
            return 0;
        }
        int n = 0;
        for (Test object : this.tests) {
            try {
                if (!object.runAsComponent()) continue;
                ++n;
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception.getMessage());
            }
        }
        int n2 = 0;
        List list = this.markBoundaries.keySet().stream().sorted().toList();
        for (Integer n3 : list) {
            if (n < n3) continue;
            n2 = this.markBoundaries.get(n3);
        }
        System.out.println("Result: " + n + "/" + this.tests.length + " successes -> " + n2 + "/" + this.getMaxMarks() + " marks");
        System.out.println("--------------------------------------");
        return n2;
    }

    @Override
    public boolean runAsComponent() {
        throw new RuntimeException();
    }
}

