/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Maybe;
import comp1110.universe.Image;
import comp1110.universe.KeyEvent;
import comp1110.universe.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class A2ComplianceTest {
    public static final String classpath = ".";
    public static final String outputDir = "_compliance";
    TypeVariable itemType = new TypeVariable("Item");
    TypeVariable directoryType = new TypeVariable("Directory");
    RequiredFunction isFile = new RequiredFunction("isFile", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.itemType}, new String[0]);
    RequiredFunction isDirectory = new RequiredFunction("isDirectory", new PrimitiveType(Boolean.TYPE), new TypeAssumption[]{this.itemType}, new String[0]);
    RequiredFunction makeFile = new RequiredFunction("makeFile", this.itemType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0]), new PrimitiveType(Integer.TYPE)}, new String[0]);
    RequiredFunction makeEmptyDirectory = new RequiredFunction("makeEmptyDirectory", this.itemType, new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction addItemToDirectory = new RequiredFunction("addItemToDirectory", this.directoryType, new TypeAssumption[]{this.directoryType, this.itemType}, new String[0]);
    RequiredFunction calculateSize = new RequiredFunction("calculateSize", new PrimitiveType(Integer.TYPE), new TypeAssumption[]{this.itemType}, new String[0]);
    RequiredFunction findByName = new RequiredFunction("findByName", new ConcreteType(Maybe.class, new TypeAssumption[0]), new TypeAssumption[]{new ConcreteType(String.class, new TypeAssumption[0]), this.itemType}, new String[0]);
    RequiredClass fileSystemClass = new RequiredClass("FileSystem", new RequiredFunction[]{this.isFile, this.isDirectory, this.makeFile, this.makeEmptyDirectory, this.addItemToDirectory, this.calculateSize, this.findByName}, new TypeVariable[]{this.itemType, this.directoryType}, new String[0]);
    TypeVariable worldType = new TypeVariable("World");
    TypeVariable marbleType = new TypeVariable("Marble");
    TypeVariable colourType = new TypeVariable("Colour");
    RequiredFunction step = new RequiredFunction("step", this.worldType, new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction draw = new RequiredFunction("draw", new ConcreteType(Image.class, new TypeAssumption[0]), new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction mouseEvent = new RequiredFunction("mouseEvent", this.worldType, new TypeAssumption[]{this.worldType, new ConcreteType(MouseEvent.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction keyEvent = new RequiredFunction("keyEvent", this.worldType, new TypeAssumption[]{this.worldType, new ConcreteType(KeyEvent.class, new TypeAssumption[0])}, new String[0]);
    RequiredFunction getMarbleAt = new RequiredFunction("getMarbleAt", new ConcreteType(Maybe.class, new TypeAssumption[0]), new TypeAssumption[]{this.worldType, new PrimitiveType(Integer.TYPE), new PrimitiveType(Integer.TYPE)}, new String[0]);
    RequiredFunction getColour = new RequiredFunction("getColour", this.colourType, new TypeAssumption[]{this.marbleType}, new String[0]);
    RequiredFunction numberOfMarblesOfColour = new RequiredFunction("numberOfMarblesOfColour", new PrimitiveType(Integer.TYPE), new TypeAssumption[]{this.worldType, this.colourType}, new String[0]);
    RequiredFunction numberOfEmptyLocations = new RequiredFunction("numberOfEmptyLocations", new PrimitiveType(Integer.TYPE), new TypeAssumption[]{this.worldType}, new String[0]);
    RequiredFunction getInitialState = new RequiredFunction("getInitialState", this.worldType, new TypeAssumption[0], new String[0]);
    RequiredClass marbleCrushClass = new RequiredClass("MarbleCrush", new RequiredFunction[]{this.step, this.draw, this.mouseEvent, this.keyEvent, this.getMarbleAt, this.getColour, this.numberOfMarblesOfColour, this.numberOfEmptyLocations, this.getInitialState}, new TypeVariable[]{this.worldType, this.marbleType, this.colourType}, new String[0]);

    public static boolean checkFileExists(String string) {
        Path path = Paths.get(string, new String[0]);
        boolean bl = Files.exists(path, new LinkOption[0]);
        if (!bl) {
            System.out.println("***FAILURE***: " + string + " not found in the current directory.");
            return false;
        }
        System.out.println("File " + string + " found.");
        return true;
    }

    public static boolean compileFile(String string) {
        new File(outputDir).mkdirs();
        JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
        if (javaCompiler == null) {
            System.err.println("CRITICAL: JDK not found. Cannot find system Java compiler -- Report this to the conveners.");
            return false;
        }
        if (javaCompiler.run(null, null, null, "--enable-preview", "--release", "23", "-d", outputDir, "-cp", classpath, new File(string).getAbsolutePath()) != 0) {
            System.out.println("***FAILURE***: Could not compile " + string + ". Please check for syntax errors.");
            return false;
        }
        System.out.println(string + " compiled successfully.");
        return true;
    }

    public static int complianceNotebook() {
        return A2ComplianceTest.checkFileExists("notebook.yml") ? 0 : 1;
    }

    public static int complianceOriginalityStatement() {
        int n;
        List<String> list;
        List<String> list2 = Arrays.asList("I declare that this work upholds the principles of academic", "integrity, as defined in the University Academic Misconduct", "Rule; is entirely my own work; is produced for the purposes", "of this assessment task and has not been submitted for", "assessment in any other context, except where authorised in", "writing by the course convener; gives appropriate", "acknowledgement of the ideas, scholarship and intellectual", "property of others insofar as these have been used; in no part", "involves copying, cheating, collusion, fabrication, plagiarism", "or recycling.", "", "I declare that I have not used any form of generative AI in", "preparing this work.", "", "I declare that I have the rights to use and submit any assets", "included in this work.", "", "[your name here]", "[your UID here]");
        int n2 = 0;
        if (!A2ComplianceTest.checkFileExists("soo.txt")) {
            return 1;
        }
        Path path = Paths.get("soo.txt", new String[0]);
        try {
            list = Files.readAllLines(path);
        }
        catch (IOException iOException) {
            System.out.println("***FAILURE***: Could not read soo.txt: " + iOException.getMessage());
            return 1;
        }
        int n3 = 0;
        for (n = 0; n3 < list2.size() && n < list.size(); ++n3, ++n) {
            while (n3 < list2.size() && list2.get(n3).trim().isEmpty()) {
                ++n3;
            }
            while (n < list.size() && list.get(n).trim().isEmpty()) {
                ++n;
            }
            if (n3 >= list2.size() || n >= list.size()) break;
            String string = list2.get(n3).trim();
            String string2 = list.get(n).trim();
            if ("[your name here]".equals(string)) {
                if (string2.contains("[") || string2.contains("]")) {
                    System.out.println("***FAILURE***: soo.txt bad signature - still contains braces.");
                    ++n2;
                }
                if (!string2.isEmpty()) continue;
                System.out.println("***FAILURE***: soo.txt no signature provided.");
                ++n2;
                continue;
            }
            if ("[your UID here]".equals(string)) {
                if (string2.length() != 8) {
                    System.out.println("***FAILURE***: UID '" + string2 + "' is not 8 characters long.");
                    ++n2;
                    continue;
                }
                if (string2.toLowerCase().charAt(0) != 'u') {
                    System.out.println("***FAILURE***: UID '" + string2 + "' does not start with 'u'.");
                    ++n2;
                }
                if (string2.substring(1).matches("\\d+")) continue;
                System.out.println("***FAILURE***: UID '" + string2 + "' does not contain 7 digits after 'u'.");
                ++n2;
                continue;
            }
            if (string.equals(string2)) continue;
            System.out.println("***FAILURE***: Mismatch of line '" + string + "' -- found: '" + string2 + "'");
            ++n2;
        }
        while (n3 < list2.size() && list2.get(n3).trim().isEmpty()) {
            ++n3;
        }
        while (n < list.size() && list.get(n).trim().isEmpty()) {
            ++n;
        }
        if (n3 < list2.size() || n < list.size()) {
            System.out.println("***FAILURE***: Statement is malformed (incorrect number of non-empty lines).");
            ++n2;
        }
        return n2;
    }

    public static int complianceComp1110Folder() {
        Path path = Paths.get("comp1110", new String[0]);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            System.out.println("***FAILURE***: folder comp1110 not found in the current folder -- Skipping further tests");
            return 1;
        }
        System.out.println("Found comp1110 folder.");
        return 0;
    }

    protected static int runComplianceTest(String string, ComplianceAction complianceAction) {
        if (!A2ComplianceTest.checkFileExists(string)) {
            System.out.println("  -- Skipping compliance tests on " + string);
            return 1;
        }
        int n = 0;
        if (A2ComplianceTest.compileFile(string)) {
            System.out.println("Running compliance on " + string);
            try {
                URL uRL = new File(outputDir).getAbsoluteFile().getCanonicalFile().toURI().toURL();
                URL uRL2 = new File(classpath).getAbsoluteFile().getCanonicalFile().toURI().toURL();
                try (URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL, uRL2}, ClassLoader.getSystemClassLoader());){
                    A2ComplianceTest a2ComplianceTest = new A2ComplianceTest();
                    n = complianceAction.execute(a2ComplianceTest, uRLClassLoader);
                    if (n == 0) {
                        System.out.println("Success! All required records and functions in " + string + " were found.");
                    } else {
                        System.out.println("***FAILURE***: " + string + " is missing one or more items. See messages above.");
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("Testing framework encountered internal error. See error information below.\n");
                System.err.println(iOException.getClass().getName() + ": " + iOException.getMessage() + "\n");
                iOException.printStackTrace();
                System.exit(1);
            }
        } else {
            n = 1;
        }
        return n;
    }

    public static int complianceFileSystem() {
        return A2ComplianceTest.runComplianceTest("FileSystem.java", (a2ComplianceTest, uRLClassLoader) -> {
            InterfaceCollector.collect(new RequiredClass[]{a2ComplianceTest.fileSystemClass}, uRLClassLoader);
            return a2ComplianceTest.fileSystemClass.checkErrors();
        });
    }

    public static int complianceMarbleCrush() {
        return A2ComplianceTest.runComplianceTest("MarbleCrush.java", (a2ComplianceTest, uRLClassLoader) -> {
            InterfaceCollector.collect(new RequiredClass[]{a2ComplianceTest.marbleCrushClass}, uRLClassLoader);
            return a2ComplianceTest.marbleCrushClass.checkErrors();
        });
    }

    public static void main(String[] stringArray) {
        System.out.println("Compliance checker for A2 version 1.02. Starting compliance check...");
        int n = 0;
        n += A2ComplianceTest.complianceNotebook();
        n += A2ComplianceTest.complianceOriginalityStatement();
        if (A2ComplianceTest.complianceComp1110Folder() == 0) {
            n += A2ComplianceTest.complianceFileSystem();
            n += A2ComplianceTest.complianceMarbleCrush();
        } else {
            ++n;
        }
        if (n == 0) {
            System.out.println("SUCCESS! Compliance check finished and no compliance issues found.");
        } else {
            System.out.println("***FAILURE*** Compliance check finished. Found " + n + " compliance issue(s).");
        }
    }

    @FunctionalInterface
    protected static interface ComplianceAction {
        public int execute(A2ComplianceTest var1, URLClassLoader var2);
    }
}

