/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Method;

public class RequiredFunction
implements RequiredComponent {
    public final String name;
    public final TypeAssumption returnType;
    public final TypeAssumption[] parameters;
    public final String[] alternateNames;
    private Method method;
    private RequiredClass klass;

    public Method getFunction() {
        return this.method;
    }

    public Class<?> getContainingClass() {
        return this.method.getDeclaringClass();
    }

    public RequiredFunction(String string, TypeAssumption typeAssumption, TypeAssumption[] typeAssumptionArray, String ... stringArray) {
        this.name = string;
        this.returnType = typeAssumption;
        this.parameters = typeAssumptionArray;
        this.alternateNames = stringArray;
    }

    void registerClass(RequiredClass requiredClass) {
        if (this.klass != null) {
            throw new IllegalStateException("Class already registered");
        }
        this.klass = requiredClass;
    }

    boolean hasMatch() {
        return this.method != null;
    }

    public boolean matches(Method method) {
        if (method.getName().equals(this.name)) {
            if (method.getParameterCount() == this.parameters.length) {
                this.method = method;
                method.setAccessible(true);
                this.returnType.addConstraint("Return type of " + this.getName(), method.getGenericReturnType(), Variance.COVARIANT);
                for (int i = 0; i < this.parameters.length; ++i) {
                    this.parameters[i].addConstraint("Argument " + i + " of " + this.getName(), method.getGenericParameterTypes()[i], Variance.CONTRAVARIANT);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean matchesExtended(Method method) {
        if (this.matchesExtendedCase(method, this.name)) {
            return true;
        }
        for (String string : this.alternateNames) {
            if (!this.matchesExtendedCase(method, string)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesExtendedCase(Method method, String string) {
        if (method.getName().equalsIgnoreCase(string) && this.returnType.matches(method.getGenericReturnType(), Variance.COVARIANT) && method.getParameterCount() == this.parameters.length) {
            int n;
            for (n = 0; n < this.parameters.length; ++n) {
                if (this.parameters[n].matches(method.getGenericParameterTypes()[n], Variance.CONTRAVARIANT)) continue;
                return false;
            }
            method.setAccessible(true);
            this.method = method;
            this.returnType.addConstraint("Return type of " + this.getName(), method.getGenericReturnType(), Variance.COVARIANT);
            for (n = 0; n < this.parameters.length; ++n) {
                this.parameters[n].addConstraint("Argument " + n + " of " + this.getName(), method.getGenericParameterTypes()[n], Variance.CONTRAVARIANT);
            }
            return true;
        }
        return false;
    }

    int checkErrors() {
        int n = 0;
        if (this.method == null) {
            ++n;
            System.out.println("***FAILURE***: Function " + this.name + " not found!");
        }
        n += this.returnType.checkConstraintErrors();
        for (TypeAssumption typeAssumption : this.parameters) {
            n += typeAssumption.checkConstraintErrors();
        }
        return n;
    }

    public Object call(Object ... objectArray) {
        try {
            return this.method.invoke(this.klass.getInstance(), objectArray);
        }
        catch (Exception exception) {
            System.out.println("Could not call function " + this.name + ": " + exception.getMessage());
            return null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.method != null;
    }
}

