/*
 * Decompiled with CFR 0.152.
 */
public abstract class TestCase
implements Test {
    public final String name;
    public final int maxMarks;
    public final RequiredClass[] requiredClasses;
    public final RequiredFunction[] requiredFunctions;
    public final TypeVariable[] typeVariables;
    public final RequiredValue[] requiredValues;

    protected TestCase(String string, int n, RequiredClass[] requiredClassArray, RequiredFunction[] requiredFunctionArray, TypeVariable[] typeVariableArray, RequiredValue[] requiredValueArray) {
        this.name = string;
        this.maxMarks = n;
        this.requiredClasses = requiredClassArray;
        this.requiredFunctions = requiredFunctionArray;
        this.typeVariables = typeVariableArray;
        this.requiredValues = requiredValueArray;
    }

    @Override
    public RequiredClass[] getRequiredClasses() {
        return this.requiredClasses;
    }

    @Override
    public RequiredFunction[] getRequiredFunctions() {
        return this.requiredFunctions;
    }

    @Override
    public TypeVariable[] getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public RequiredValue[] getRequiredValues() {
        return this.requiredValues;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getMaxMarks() {
        return this.maxMarks;
    }

    @Override
    public int runTest() {
        System.out.println("Test " + this.name + " (" + this.maxMarks + " marks)");
        System.out.println("--------------------------------------");
        if (!this.canRun()) {
            System.out.println("Cannot run. Missing components: " + String.join((CharSequence)", ", this.missingComponents()));
            System.out.println("--------------------------------------");
            return 0;
        }
        int n = 0;
        try {
            n = this.testImpl();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
        System.out.println("--------------------------------------");
        System.out.println("Result: " + n + "/" + this.maxMarks + " marks");
        System.out.println("--------------------------------------");
        return n;
    }

    @Override
    public boolean runAsComponent() {
        System.out.println("Test " + this.name);
        System.out.println("--------------------------------------");
        if (!this.canRun()) {
            System.out.println("Cannot run. Missing components: " + String.join((CharSequence)", ", this.missingComponents()));
            System.out.println("--------------------------------------");
            return false;
        }
        int n = 0;
        try {
            n = this.testImpl();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception.getMessage());
        }
        System.out.println("--------------------------------------");
        System.out.println("Result: " + (n > 0 ? "Success!" : "Failure!"));
        System.out.println("--------------------------------------");
        return n > 0;
    }

    public abstract int testImpl();
}

