/*
 * Decompiled with CFR 0.152.
 */
import comp1110.lib.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TypeVariable
implements TypeAssumption {
    private Type type;
    private final List<Pair<String, Type>> upperBounds = new ArrayList<Pair<String, Type>>();
    private final List<Pair<String, Type>> lowerBounds = new ArrayList<Pair<String, Type>>();
    public final String name;

    @Override
    public boolean addConstraint(String string, Type type, Variance variance) {
        boolean bl = true;
        if (this.type == null && this.upperBounds.isEmpty() && this.lowerBounds.isEmpty()) {
            this.type = type;
        } else if (this.type != null && !type.equals(this.type) && !Util.CheckSubtyping(type, this.type, variance)) {
            this.type = null;
        }
        switch (variance) {
            case INVARIANT: {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                break;
            }
            case COVARIANT: {
                this.lowerBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
                break;
            }
            case CONTRAVARIANT: {
                this.upperBounds.add((Pair<String, Type>)new Pair((Object)string, (Object)type));
            }
        }
        if (this.type == null) {
            ArrayList<Type> arrayList = new ArrayList<Type>();
            for (Pair<String, Type> object : this.upperBounds) {
                if (arrayList.contains(object.second())) continue;
                arrayList.add((Type)object.second());
            }
            for (Pair<String, Type> pair : this.lowerBounds) {
                if (arrayList.contains(pair.second())) continue;
                arrayList.add((Type)pair.second());
            }
            for (Type type2 : arrayList) {
                boolean bl2 = true;
                for (Pair<String, Type> pair : this.upperBounds) {
                    if (Util.CheckSubtyping((Type)pair.second(), type2, Variance.CONTRAVARIANT)) continue;
                    bl2 = false;
                    break;
                }
                for (Pair<String, Type> pair : this.lowerBounds) {
                    if (Util.CheckSubtyping((Type)pair.second(), type2, Variance.COVARIANT)) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                this.type = type2;
                break;
            }
        }
        return bl;
    }

    @Override
    public boolean matches(Type type, Variance variance) {
        return this.type == null || this.type.equals(type) || this.upperBounds.stream().allMatch(pair -> Util.SubtypeOf(type, (Type)pair.second(), new HashMap())) && this.lowerBounds.stream().allMatch(pair -> Util.SubtypeOf((Type)pair.second(), type, new HashMap()));
    }

    @Override
    public int checkErrors() {
        int n = 0;
        if (this.type != null) {
            for (Pair<String, Type> pair : this.upperBounds) {
                if (((Type)pair.second()).equals(this.type)) continue;
                System.out.println("Different types found for " + this.name + ", but " + this.type.getTypeName() + " is supertype of all of them.");
                return 0;
            }
            for (Pair<String, Type> pair : this.lowerBounds) {
                if (((Type)pair.second()).equals(this.type)) continue;
                System.out.println("Different types found for " + this.name + ", but " + this.type.getTypeName() + " is supertype of all of them.");
                return 0;
            }
            return 0;
        }
        if (!this.lowerBounds.isEmpty() || !this.upperBounds.isEmpty()) {
            System.out.println("Different types found for " + this.name + ":");
            ArrayList<Type> arrayList = new ArrayList<Type>();
            for (Pair<String, Type> pair : this.upperBounds) {
                if (arrayList.contains(pair.second())) continue;
                arrayList.add((Type)pair.second());
            }
            for (Pair<String, Type> pair : this.lowerBounds) {
                if (arrayList.contains(pair.second())) continue;
                arrayList.add((Type)pair.second());
            }
            System.out.println(String.join((CharSequence)", ", arrayList.stream().map(Type::getTypeName).toList()));
            ++n;
        } else {
            System.out.println("***FAILURE***: No types found for " + this.name + "!");
            ++n;
        }
        return n;
    }

    @Override
    public int checkConstraintErrors() {
        return this.type == null ? 1 : 0;
    }

    @Override
    public Type asType() {
        return this.type != null ? this.type : Void.TYPE;
    }

    public TypeVariable(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.type != null;
    }
}

