/*
 * Decompiled with CFR 0.152.
 */
package comp1110.console;

import java.util.Scanner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public class ConsoleApp {
    private static boolean ignoreWaitAtEnd = false;

    static void setIgnoreWaitAtEnd() {
        ignoreWaitAtEnd = true;
    }

    public static <State> void Start(State startState, Function<State, State> step, Predicate<State> hasStopped) {
        ConsoleApp.Start(startState, step, hasStopped, true);
    }

    public static <State> void Start(State startState, Function<State, State> step, Predicate<State> hasStopped, boolean waitAtEnd) {
        while (!hasStopped.test(startState)) {
            startState = step.apply(startState);
        }
        if (waitAtEnd && !ignoreWaitAtEnd) {
            System.out.println("Console Application has ended. Press enter to finish.");
            Scanner scanner = new Scanner(System.in);
            scanner.nextLine();
        }
    }

    public static <State> void Start(State startState, BiFunction<State, String, State> step, Predicate<State> hasStopped) {
        ConsoleApp.Start(startState, step, hasStopped, true);
    }

    public static <State> void Start(State startState, BiFunction<State, String, State> step, Predicate<State> hasStopped, boolean waitAtEnd) {
        Scanner scanner = new Scanner(System.in);
        while (!hasStopped.test(startState)) {
            startState = step.apply(startState, scanner.nextLine());
        }
        if (waitAtEnd && !ignoreWaitAtEnd) {
            System.out.println("Console Application has ended. Press enter to finish.");
            scanner.nextLine();
        }
    }
}

