/*
 * Decompiled with CFR 0.152.
 */
package comp1110.lib;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;

public class Date
implements Comparable<Date> {
    ZonedDateTime dt;
    String tz;

    Date(ZonedDateTime dt, String tz) {
        this.dt = dt;
        this.tz = tz;
    }

    public boolean equals(Object o) {
        if (o instanceof Date) {
            ZonedDateTime other = ((Date)o).dt;
            return this.dt.getLong(ChronoField.INSTANT_SECONDS) == other.getLong(ChronoField.INSTANT_SECONDS) && this.dt.getLong(ChronoField.NANO_OF_SECOND) == other.getLong(ChronoField.NANO_OF_SECOND);
        }
        return false;
    }

    public int hashCode() {
        return (int)((this.dt.getLong(ChronoField.INSTANT_SECONDS) + this.dt.getLong(ChronoField.NANO_OF_SECOND) * 17L) % 0xFFFFFFFFL);
    }

    public String toString() {
        return this.dt.getYear() + "-" + this.dt.getMonthValue() + "-" + this.dt.getDayOfMonth();
    }

    Date addDays(long days) {
        return new Date(this.dt.plusDays(days), this.tz);
    }

    Date addMonths(long months) {
        return new Date(this.dt.plusMonths(months), this.tz);
    }

    Date addYears(long years) {
        return new Date(this.dt.plusYears(years), this.tz);
    }

    @Override
    public int compareTo(Date o) {
        return this.dt.compareTo(o.dt);
    }
}

