/*
 * Decompiled with CFR 0.152.
 */
package comp1110.lib;

import comp1110.lib.Date;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;

public class DateTime
extends Date {
    DateTime(ZonedDateTime dt, String timeZone) {
        super(dt, timeZone);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.dt.getHour() + ":" + this.dt.getMinute() + ":" + this.dt.getSecond() + (String)(this.dt.get(ChronoField.MILLI_OF_SECOND) != 0 ? ":" + this.dt.get(ChronoField.MILLI_OF_SECOND) : "");
    }

    @Override
    DateTime addDays(long days) {
        return new DateTime(days >= 0L ? this.dt.plusDays(days) : this.dt.minusDays(-days), this.tz);
    }

    @Override
    DateTime addMonths(long months) {
        return new DateTime(months >= 0L ? this.dt.plusMonths(months) : this.dt.minusMonths(-months), this.tz);
    }

    @Override
    DateTime addYears(long years) {
        return new DateTime(years >= 0L ? this.dt.plusYears(years) : this.dt.minusYears(-years), this.tz);
    }

    DateTime addMilliseconds(long milliseconds) {
        return new DateTime(milliseconds >= 0L ? this.dt.plus(milliseconds, ChronoUnit.MILLIS) : this.dt.minus(-milliseconds, ChronoUnit.MILLIS), this.tz);
    }

    DateTime addSeconds(long seconds) {
        return new DateTime(seconds >= 0L ? this.dt.plusSeconds(seconds) : this.dt.minusSeconds(-seconds), this.tz);
    }

    DateTime addMinutes(long minutes) {
        return new DateTime(minutes >= 0L ? this.dt.plusMinutes(minutes) : this.dt.minusMinutes(-minutes), this.tz);
    }

    DateTime addHours(long hours) {
        return new DateTime(hours >= 0L ? this.dt.plusHours(hours) : this.dt.minusHours(-hours), this.tz);
    }
}

