/*
 * Decompiled with CFR 0.152.
 */
package comp1110.lib;

import comp1110.lib.Comp1110DefaultCaseException;
import comp1110.lib.Comp1110Exception;
import comp1110.lib.Cons;
import comp1110.lib.ConsList;
import comp1110.lib.Date;
import comp1110.lib.DateTime;
import comp1110.lib.Maybe;
import comp1110.lib.Nil;
import comp1110.lib.Nothing;
import comp1110.lib.Pair;
import comp1110.lib.Something;
import java.lang.runtime.SwitchBootstraps;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.Predicate;

public class Functions {
    static Random random;
    private static final Thread.UncaughtExceptionHandler origUEH;
    private static final List<String> comp1110UnitExceptions;
    private static final String[] compatibleVersions;
    public static final double PI = Math.PI;
    public static final double E = Math.E;

    private Functions() {
    }

    public static void SetStandardErrorHandler() {
        Thread.setDefaultUncaughtExceptionHandler(origUEH);
    }

    public static void SetComp1110ErrorHandler() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> Functions.HandleException(e));
    }

    private static void PrintErrorMessage(StackTraceElement[] sTEs, String message) {
        StackTraceElement[] cleanSTEs = Functions.RemoveUntilPrefixFromStackTrace(sTEs, "comp1110.lib.", comp1110UnitExceptions);
        Object location = "unknown location";
        if (cleanSTEs.length > 0) {
            location = "line " + cleanSTEs[0].getLineNumber() + " in '" + cleanSTEs[0].getFileName() + "'";
        }
        System.err.println("Error at " + (String)location + ": " + message);
    }

    private static void HandleException(Throwable e) {
        Functions.ExplainException(e);
        System.exit(1);
    }

    public static void ExplainException(Throwable e) {
        Functions.ExplainException(e, AbortReason.DEFAULT);
    }

    private static void ExplainException(Throwable e, AbortReason reason) {
        StackTraceElement[] cleanSTEs = Functions.RemoveUntilPrefixFromStackTrace(e.getStackTrace(), "comp1110.lib.", comp1110UnitExceptions);
        Object location = "unknown location";
        if (cleanSTEs.length > 0) {
            location = "line " + cleanSTEs[0].getLineNumber() + " in '" + cleanSTEs[0].getFileName() + "'";
        }
        Throwable throwable = e;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Comp1110WrappedException.class, Comp1110LibException.class, Comp1110Exception.class, Comp1110DefaultCaseException.class, NullPointerException.class, IndexOutOfBoundsException.class, ArithmeticException.class, IllegalFormatException.class, IllegalArgumentException.class}, (Throwable)throwable2, n)) {
            case 0: {
                Comp1110WrappedException comp1110WrappedException = (Comp1110WrappedException)throwable2;
                Functions.ExplainException(comp1110WrappedException.getCause(), comp1110WrappedException.reason);
                break;
            }
            case 1: {
                Comp1110LibException comp1110LibException = (Comp1110LibException)throwable2;
                System.err.println("Error at " + (String)location + ": " + comp1110LibException.getMessage());
                break;
            }
            case 2: {
                Comp1110Exception comp1110Exception = (Comp1110Exception)throwable2;
                System.err.println("Error! You indicated an error at " + (String)location + (String)(!comp1110Exception.getMessage().isEmpty() ? ": " + comp1110Exception.getMessage() : ""));
                break;
            }
            case 3: {
                Comp1110DefaultCaseException comp1110DefaultCaseException = (Comp1110DefaultCaseException)throwable2;
                System.err.println("Error! You indicated an unexpected default branch at " + (String)location + " that was reached during execution!\n" + comp1110DefaultCaseException.getMessage());
                break;
            }
            case 4: {
                NullPointerException nullPointerException = (NullPointerException)throwable2;
                System.err.println("Error! You tried to use a [null] value at " + (String)location + "!");
                System.err.println("Did you assign a reasonable value to all variables?");
                break;
            }
            case 5: {
                IndexOutOfBoundsException indexOutOfBoundsException = (IndexOutOfBoundsException)throwable2;
                System.err.println("Error! You tried to use an invalid index at " + (String)location + "!");
                System.err.println("This can happen when you are trying to use a negative number or a number that's too big to access an array, or part of a String");
                System.err.println("Java's error message: " + e.getMessage());
                break;
            }
            case 6: {
                ArithmeticException arithmeticException = (ArithmeticException)throwable2;
                System.err.println("Error! A calculation you tried to make at " + (String)location + " went wrong!");
                System.err.println("This mostly happens when you try to divide by 0.");
                System.err.println("Java's error message: " + e.getMessage());
                break;
            }
            case 7: {
                IllegalFormatException illegalFormatException = (IllegalFormatException)throwable2;
                System.err.println("Error! You tried to format something to a String at " + (String)location + ", but the format String you gave is invalid.");
                System.err.println("Check that you have the right number of arguments, and are using the right types!");
                System.err.println("Java's error message: " + e.getMessage());
                break;
            }
            case 8: {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable2;
                if (reason == AbortReason.DATE_PATTERN) {
                    System.err.println("Error! You gave an illegal date pattern at " + (String)location + "!");
                    System.err.println("Java's error message: " + e.getMessage());
                    break;
                }
                System.err.println("Error! You gave an illegal argument to an operation at " + (String)location + ".");
                System.err.println("Try checking the documentation of that operation!");
                System.err.println("Java's error message: " + e.getMessage());
                break;
            }
            default: {
                System.err.println("Error at " + (String)location + ": " + e.getMessage() + " [" + e.getClass().getName() + "]");
            }
        }
    }

    static StackTraceElement[] RemovePrefixFromStackTrace(StackTraceElement[] stackTrace, String classNamePrefix) {
        return (StackTraceElement[])Arrays.stream(stackTrace).filter(ste -> !ste.getClassName().startsWith(classNamePrefix)).toArray(StackTraceElement[]::new);
    }

    static StackTraceElement[] RemoveUntilPrefixFromStackTrace(StackTraceElement[] stackTrace, String classNamePrefix, List<String> exceptMethods) {
        int lastClassNamePos = -1;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (lastClassNamePos == -1 && exceptMethods.contains(stackTrace[i].getClassName() + "." + stackTrace[i].getMethodName())) {
                for (int j = 0; j < i; ++j) {
                    if (!stackTrace[i].getClassName().contains(".")) continue;
                    lastClassNamePos = j + 1;
                }
                if (lastClassNamePos != i) break;
                lastClassNamePos = i + 1;
            }
            if (!stackTrace[i].getClassName().startsWith(classNamePrefix)) continue;
            lastClassNamePos = i + 1;
        }
        if (lastClassNamePos >= 0) {
            StackTraceElement[] ret = new StackTraceElement[stackTrace.length - lastClassNamePos];
            System.arraycopy(stackTrace, lastClassNamePos, ret, 0, stackTrace.length - lastClassNamePos);
            return ret;
        }
        return stackTrace;
    }

    public static <T> T Error() {
        throw new Comp1110Exception();
    }

    public static <T> T Error(String message) {
        throw new Comp1110Exception(message);
    }

    public static <T> T DefaultCaseError() {
        throw new Comp1110DefaultCaseException();
    }

    public static <T> T DefaultCaseError(String message) {
        throw new Comp1110DefaultCaseException(message);
    }

    public static String GetVersion() {
        return "2025S1-7";
    }

    public static void CheckVersion(String version) {
        for (String cv : compatibleVersions) {
            if (!version.equals(cv)) continue;
            return;
        }
        throw new Comp1110Exception("Incompatible version detected! These are the COMP1110 libraries version " + Functions.GetVersion() + ", which are not compatible with the requested version " + version + "!");
    }

    public static boolean Equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static <T extends Comparable<T>> int Compare(T left, T right) {
        return left.compareTo(right);
    }

    public static <T extends Comparable<T>> T Min(T left, T right) {
        if (left.compareTo(right) <= 0) {
            return left;
        }
        return right;
    }

    public static <T extends Comparable<T>> T Max(T left, T right) {
        if (left.compareTo(right) >= 0) {
            return left;
        }
        return right;
    }

    public static <T extends Comparable<T>> boolean GreaterThan(T bigger, T smaller) {
        return bigger.compareTo(smaller) > 0;
    }

    public static <T extends Comparable<T>> boolean LessThan(T smaller, T bigger) {
        return smaller.compareTo(bigger) < 0;
    }

    public static int RandomNumber(int min, int max) {
        if (random == null) {
            random = new Random();
        }
        return random.nextInt(min, max);
    }

    public static int RandomNumber(int max) {
        if (random == null) {
            random = new Random();
        }
        return random.nextInt(max);
    }

    public static int RandomNumber() {
        if (random == null) {
            random = new Random();
        }
        return random.nextInt();
    }

    public static String ToString(Object o) {
        return o.toString();
    }

    public static boolean IsIntString(String str) {
        try {
            int x = Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static int StringToInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            throw new Comp1110LibException("\"" + str + "\" is not a valid decimal integer representation!\nRemember: the String may start with either a '+' or '-' sign (but does not have to), and must otherwise only consist of digit characters 0-9.");
        }
    }

    public static boolean IsFloatString(String str) {
        try {
            float x = Float.parseFloat(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static float StringToFloat(String str) {
        try {
            return Float.parseFloat(str);
        }
        catch (NumberFormatException e) {
            throw new Comp1110LibException("\"" + str + "\" is not a valid decimal float representation!\nRemember: the String may start with either a '+' or '-' sign (but does not have to), and must otherwise only consist of digit characters 0-9, and up to one '.' character.");
        }
    }

    public static boolean IsDoubleString(String str) {
        try {
            double x = Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double StringToDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            throw new Comp1110LibException("\"" + str + "\" is not a valid decimal double representation!\nRemember: the String may start with either a '+' or '-' sign (but does not have to), and must otherwise only consist of digit characters 0-9, and up to one '.' character.");
        }
    }

    public static boolean IsLongString(String str) {
        try {
            long x = Long.parseLong(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double StringToLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            throw new Comp1110LibException("\"" + str + "\" is not a valid decimal long representation!\nRemember: the String may start with either a '+' or '-' sign (but does not have to), and must otherwise only consist of digit characters 0-9.");
        }
    }

    public static boolean StringToBoolean(String str) {
        return Boolean.parseBoolean(str);
    }

    public static String Format(String format, Object ... args) {
        return String.format(format, args);
    }

    public static String Concatenate(String ... strings) {
        return String.join((CharSequence)"", strings);
    }

    public static String SubString(String s, int beginIndex) {
        return s.substring(beginIndex);
    }

    public static String SubString(String s, int beginIndex, int endIndex) {
        return s.substring(beginIndex, endIndex);
    }

    public static Boolean Contains(String haystack, String needle) {
        return haystack.contains(needle);
    }

    public static Boolean StartsWith(String string, String prefix) {
        return string.startsWith(prefix);
    }

    public static Boolean EndsWith(String string, String postfix) {
        return string.endsWith(postfix);
    }

    public static String Replace(String replace, String withString, String inString) {
        return inString.replace(replace, withString);
    }

    public static int Length(CharSequence cs) {
        return cs.length();
    }

    public static <T> int Length(T[] array) {
        return array.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int Length(ConsList<?> list) {
        Object rest;
        ConsList<?> consList = list;
        Objects.requireNonNull(consList);
        ConsList<?> consList2 = consList;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                return 0;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object object;
            Object first = object = cons.element();
            rest = object = cons.rest();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int n = 1 + Functions.Length(rest);
        return n;
    }

    public static int IndexOf(String find, String inString) {
        return inString.indexOf(find);
    }

    public static int IndexOf(String find, String inString, int fromIndex) {
        return inString.indexOf(find, fromIndex);
    }

    public static int LastIndexOf(String find, String inString) {
        return inString.lastIndexOf(find);
    }

    public static int LastIndexOf(String find, String inString, int fromIndex) {
        return inString.lastIndexOf(find, fromIndex);
    }

    public static String Trim(String str) {
        return str.trim();
    }

    public static String UpperCase(String str) {
        return str.toUpperCase();
    }

    public static String LowerCase(String str) {
        return str.toLowerCase();
    }

    public static char GetCharAt(String str, int index) {
        return str.charAt(index);
    }

    @SafeVarargs
    public static <T> ConsList<T> MakeList(T ... ts) {
        if (ts == null) {
            return new Nil();
        }
        Record ret = new Nil();
        for (int i = ts.length - 1; i >= 0; --i) {
            ret = new Cons<T>(ts[i], ret);
        }
        return ret;
    }

    private static <T> ConsList<T> MakeList(Collection<T> ts) {
        if (ts == null) {
            return new Nil();
        }
        Record ret = new Nil();
        for (T t : ts) {
            ret = new Cons<T>(t, ret);
        }
        return Functions.FoldLeft(Cons::new, new Nil(), ret);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> ConsList<T> Snoc(ConsList<? extends T> list, T value) {
        Cons cons;
        ConsList<? extends T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends T> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                cons = new Cons(value, new Nil());
                return cons;
            }
            case 1: 
        }
        Cons cons2 = (Cons)consList2;
        try {
            Object object;
            Object first = object = cons2.element();
            Object rest = object = cons2.rest();
            cons = new Cons(first, Functions.Snoc(rest, value));
            return cons;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> ConsList<T> insertSorted(T elem, ConsList<T> list, BiFunction<? super T, ? super T, Integer> comparator) {
        Cons<T> cons;
        ConsList<T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<T> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                cons = new Cons<T>(elem, new Nil());
                return cons;
            }
            case 1: 
        }
        Cons cons2 = (Cons)consList2;
        try {
            Object object;
            Object first = object = cons2.element();
            Object rest = object = cons2.rest();
            if (comparator.apply(elem, first) <= 0) {
                cons = new Cons<T>(elem, new Cons(first, rest));
                return cons;
            }
            cons = new Cons(first, Functions.insertSorted(elem, rest, comparator));
            return cons;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ConsList<T> Sort(ConsList<? extends T> list, BiFunction<? super T, ? super T, Integer> comparator) {
        Object rest;
        Object first;
        ConsList<Object> consList;
        ConsList<? extends T> consList2 = list;
        Objects.requireNonNull(consList2);
        ConsList<? extends T> consList22 = consList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList22;
                consList = new Nil();
                return consList;
            }
            case 1: 
        }
        Cons cons = (Cons)consList22;
        try {
            Object object;
            first = object = cons.element();
            rest = object = cons.rest();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        consList = Functions.insertSorted(first, Functions.Sort(rest, comparator), comparator);
        return consList;
    }

    public static <T extends Comparable<T>> ConsList<T> Sort(ConsList<? extends T> list) {
        return Functions.Sort(list, Functions::Compare);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ConsList<T> Append(ConsList<? extends T> list1, ConsList<? extends T> list2) {
        ConsList<Object> consList;
        ConsList<? extends T> consList2 = list1;
        Objects.requireNonNull(consList2);
        ConsList<? extends T> consList22 = consList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList22;
                ConsList<? extends T> consList3 = list2;
                Objects.requireNonNull(consList3);
                ConsList<? extends T> consList4 = consList3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList4, n2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Nil nil2 = (Nil)consList4;
                        consList = new Nil();
                        return consList;
                    }
                    case 1: 
                }
                Cons cons = (Cons)consList4;
                try {
                    Object object;
                    Object first = object = cons.element();
                    Object rest = object = cons.rest();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                consList = Functions.Append(list2, new Nil());
                return consList;
            }
            case 1: 
        }
        Cons cons = (Cons)consList22;
        {
            Object object;
            Object first = object = cons.element();
            Object rest = object = cons.rest();
            consList = new Cons<T>(first, Functions.Append(rest, list2));
        }
        return consList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T> ConsList<T> Map(Function<S, T> mapper, ConsList<? extends S> list) {
        Record record;
        ConsList<? extends S> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends S> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                record = new Nil();
                return record;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object object;
            Object first = object = cons.element();
            Object rest = object = cons.rest();
            record = new Cons(mapper.apply(first), Functions.Map(mapper, rest));
            return record;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T, U> ConsList<U> Map(BiFunction<S, T, U> mapper, ConsList<? extends S> list1, ConsList<? extends T> list2) {
        ConsList<? extends T> consList;
        Object rest;
        Object first;
        Object object2;
        Record record;
        ConsList<? extends S> consList2 = list1;
        Objects.requireNonNull(consList2);
        ConsList<? extends S> consList22 = consList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList22;
                ConsList<? extends T> consList3 = list2;
                Objects.requireNonNull(consList3);
                ConsList<? extends T> consList4 = consList3;
                int n2 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList4, n2)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Nil nil2 = (Nil)consList4;
                        record = new Nil();
                        return record;
                    }
                    case 1: 
                }
                Cons cons = (Cons)consList4;
                try {
                    Object object;
                    Object first2 = object = cons.element();
                    Object rest2 = object = cons.rest();
                    throw new Comp1110Exception("Tried to map to lists of different length - list2 is longer than list1!");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Cons cons = (Cons)consList22;
        {
            first = object2 = cons.element();
            rest = object2 = cons.rest();
            consList = list2;
        }
        Objects.requireNonNull(consList);
        object2 = consList;
        int n3 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, object2, n3)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)object2;
                throw new Comp1110Exception("Tried to map to lists of different length - list1 is longer that list2!");
            }
            case 1: 
        }
        Cons cons2 = (Cons)object2;
        {
            Object object;
            Object first2 = object = cons2.element();
            Object rest2 = object = cons2.rest();
            record = new Cons(mapper.apply(first, first2), Functions.Map(mapper, rest, rest2));
        }
        return record;
    }

    public static <S, T> ConsList<Pair<S, T>> Zip(ConsList<? extends S> ss, ConsList<? extends T> ts) {
        return Functions.Map(Pair::new, ss, ts);
    }

    public static <S, T> Pair<ConsList<S>, ConsList<T>> Unzip(ConsList<? extends Pair<? extends S, ? extends T>> list) {
        return new Pair<ConsList<S>, ConsList<T>>(Functions.Map(Pair::first, list), Functions.Map(Pair::second, list));
    }

    public static ConsList<Integer> BuildList(int length) {
        Record ret = new Nil<Integer>();
        while (length > 0) {
            ret = new Cons<Integer>(--length, (ConsList<Integer>)((Object)ret));
        }
        return ret;
    }

    public static <T> ConsList<T> BuildList(int length, T value) {
        Record ret = new Nil();
        while (length > 0) {
            ret = new Cons<T>(value, ret);
            --length;
        }
        return ret;
    }

    public static <T> ConsList<T> BuildList(int length, Function<Integer, T> intFun) {
        ConsList ret = new Nil();
        for (int i = 0; i < length; ++i) {
            T value = intFun.apply(i);
            ret = Functions.Snoc(ret, value);
        }
        return ret;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T, U> ConsList<U> Map(BiFunction<S, T, U> mapper, ConsList<? extends Pair<? extends S, ? extends T>> list) {
        Object snd;
        Object fst;
        Object rest;
        Record record;
        ConsList<? extends Pair<? extends S, ? extends T>> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends Pair<? extends S, ? extends T>> consList2 = consList;
        int n = 0;
        while (true) {
            Object object;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    Nil nil = (Nil)consList2;
                    record = new Nil();
                    return record;
                }
                case 1: 
            }
            Cons cons = (Cons)consList2;
            try {
                object = (Pair)cons.element();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (object instanceof Pair) {
                Pair pair = object;
                {
                    rest = object = cons.rest();
                    fst = object = pair.first();
                    snd = object = pair.second();
                    break;
                }
            }
            n = 2;
        }
        record = new Cons<Object>(mapper.apply(fst, snd), Functions.Map(mapper, rest));
        return record;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T> T Fold(BiFunction<S, T, T> aggregator, T start, ConsList<? extends S> list) {
        T t;
        ConsList<? extends S> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends S> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                t = start;
                return t;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object object;
            Object first = object = cons.element();
            Object rest = object = cons.rest();
            t = aggregator.apply(first, Functions.Fold(aggregator, start, rest));
            return t;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T> T FoldLeft(BiFunction<S, T, T> aggregator, T start, ConsList<? extends S> list) {
        Object rest;
        Object first;
        T t;
        ConsList<? extends S> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends S> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                t = start;
                return t;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object object;
            first = object = cons.element();
            rest = object = cons.rest();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        t = Functions.FoldLeft(aggregator, aggregator.apply(first, start), rest);
        return t;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> ConsList<T> Filter(Predicate<T> predicate, ConsList<? extends T> list) {
        Object rest;
        ConsList consList;
        ConsList<? extends T> consList2 = list;
        Objects.requireNonNull(consList2);
        ConsList<? extends T> consList22 = consList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList22;
                consList = new Nil();
                return consList;
            }
            case 1: 
        }
        Cons cons = (Cons)consList22;
        try {
            Object object;
            Object first = object = cons.element();
            rest = object = cons.rest();
            if (predicate.test(first)) {
                consList = new Cons(first, Functions.Filter(predicate, rest));
                return consList;
            }
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        consList = Functions.Filter(predicate, rest);
        return consList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> boolean IsEmpty(ConsList<? extends T> list) {
        ConsList<? extends T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends T> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                return true;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object object = cons.element();
            object = cons.rest();
            return false;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    public static <T> T First(ConsList<? extends T> list) {
        Object first;
        Object object;
        ConsList<? extends T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends T> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                throw new Comp1110LibException("You called First on an empty list!");
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            first = object = cons.element();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object rest = object = cons.rest();
        return first;
    }

    public static <T> ConsList<T> Rest(ConsList<? extends T> list) {
        Object object;
        ConsList<? extends T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends T> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                throw new Comp1110LibException("You called Rest on an empty list!");
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            Object first = object = cons.element();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object rest = object = cons.rest();
        return rest;
    }

    public static <T> T Nth(ConsList<? extends T> list, int n) {
        Object first;
        Object object;
        if (n < 0) {
            throw new Comp1110LibException("Argument to Nth must be >= 0!");
        }
        ConsList<? extends T> consList = list;
        Objects.requireNonNull(consList);
        ConsList<? extends T> consList2 = consList;
        int n2 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n2)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                throw new Comp1110LibException("You called Nth on a list that is too short!");
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            first = object = cons.element();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object rest = object = cons.rest();
        return n == 0 ? first : Functions.Nth(rest, n - 1);
    }

    public static int Abs(int i) {
        return Math.absExact(i);
    }

    public static long Abs(long l) {
        return Math.absExact(l);
    }

    public static double Abs(double d) {
        return Math.abs(d);
    }

    public static float Abs(float f) {
        return Math.abs(f);
    }

    public static double Exp(double exp) {
        return Math.exp(exp);
    }

    public static double Pow(double number, double exponent) {
        return Math.pow(number, exponent);
    }

    public static double Sqrt(double number) {
        return Math.sqrt(number);
    }

    public static long Round(double number) {
        return Math.round(number);
    }

    public static long Ceil(double number) {
        return Math.round(Math.ceil(number));
    }

    public static double Floor(double number) {
        return Math.round(Math.floor(number));
    }

    public static int RoundInt(double number) {
        try {
            return Math.toIntExact(Math.round(number));
        }
        catch (ArithmeticException e) {
            throw new Comp1110LibException("Tried to round a number to an int whose absolute value was too large: " + number);
        }
    }

    public static int CeilInt(double number) {
        try {
            return Math.toIntExact(Math.round(Math.ceil(number)));
        }
        catch (ArithmeticException e) {
            throw new Comp1110LibException("Tried to round a number to an int whose absolute value was too large: " + number);
        }
    }

    public static int FloorInt(double number) {
        try {
            return Math.toIntExact(Math.round(Math.floor(number)));
        }
        catch (ArithmeticException e) {
            throw new Comp1110LibException("Tried to round a number to an int whose absolute value was too large: " + number);
        }
    }

    public static double Log(double number) {
        return Math.log(number);
    }

    public static double Log10(double number) {
        return Math.log10(number);
    }

    public static double Sin(double number) {
        return Math.sin(number);
    }

    public static double Cos(double number) {
        return Math.cos(number);
    }

    public static double Tan(double number) {
        return Math.tan(number);
    }

    public static double ASin(double number) {
        return Math.asin(number);
    }

    public static double ACos(double number) {
        return Math.acos(number);
    }

    public static double ATan(double number) {
        return Math.atan(number);
    }

    public static Date CurrentDate() {
        return Functions.CurrentDate(TimeZone.getDefault().getID());
    }

    public static Date CurrentDate(String timeZone) {
        if (!ZoneId.getAvailableZoneIds().contains(timeZone)) {
            throw new Comp1110LibException(timeZone + " is not a valid timezone descriptor");
        }
        ZonedDateTime dt = ZonedDateTime.now(ZoneId.of(timeZone)).truncatedTo(ChronoUnit.DAYS);
        return new Date(dt, timeZone);
    }

    public static DateTime CurrentTime() {
        return Functions.CurrentTime(ZoneId.systemDefault().getId());
    }

    public static DateTime CurrentTime(String timeZone) {
        if (!ZoneId.getAvailableZoneIds().contains(timeZone)) {
            throw new Comp1110LibException(timeZone + " is not a valid timezone descriptor");
        }
        ZonedDateTime dt = ZonedDateTime.now(ZoneId.of(timeZone));
        return new DateTime(dt, timeZone);
    }

    public static Date GetDate(int year, int month, int day) {
        return Functions.GetDate(year, month, day, TimeZone.getDefault().getID());
    }

    public static Date GetDate(int year, int month, int day, String timeZone) {
        if (!ZoneId.getAvailableZoneIds().contains(timeZone)) {
            throw new Comp1110LibException(timeZone + " is not a valid timezone descriptor");
        }
        try {
            ZonedDateTime dt = ZonedDateTime.of(year, month, day, 0, 0, 0, 0, ZoneId.of(timeZone));
            return new Date(dt, timeZone);
        }
        catch (DateTimeException e) {
            throw new Comp1110LibException("Invalid arguments to GetDate: " + e.getMessage());
        }
    }

    public static boolean IsDateValid(int year, int month, int day) {
        return Functions.IsDateValid(year, month, day, TimeZone.getDefault().getID());
    }

    public static boolean IsDateValid(int year, int month, int day, String timeZone) {
        if (!ZoneId.getAvailableZoneIds().contains(timeZone)) {
            return false;
        }
        try {
            ZonedDateTime dt = ZonedDateTime.of(year, month, day, 0, 0, 0, 0, ZoneId.of(timeZone));
            return true;
        }
        catch (DateTimeException e) {
            return false;
        }
    }

    public static DateTime GetDateTime(int year, int month, int day, int hour, int minute, int second) {
        return Functions.GetDateTime(year, month, day, hour, minute, second, 0);
    }

    public static DateTime GetDateTime(int year, int month, int day, int hour, int minute, int second, String timeZone) {
        return Functions.GetDateTime(year, month, day, hour, minute, second, 0, timeZone);
    }

    public static DateTime GetDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        return Functions.GetDateTime(year, month, day, hour, minute, second, millisecond, TimeZone.getDefault().getID());
    }

    public static DateTime GetDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, String timeZone) {
        if (!ZoneId.getAvailableZoneIds().contains(timeZone)) {
            throw new Comp1110LibException(timeZone + " is not a valid timezone descriptor");
        }
        try {
            ZonedDateTime dt = ZonedDateTime.of(year, month, day, hour, minute, second, 0, ZoneId.of(timeZone)).with(ChronoField.MILLI_OF_SECOND, millisecond);
            return new DateTime(dt, timeZone);
        }
        catch (DateTimeException e) {
            throw new Comp1110LibException("Invalid arguments to GetDateTime: " + e.getMessage());
        }
    }

    public static int GetYear(Date date) {
        return date.dt.getYear();
    }

    public static int GetMonth(Date date) {
        return date.dt.getMonthValue();
    }

    public static int GetDay(Date date) {
        return date.dt.getDayOfMonth();
    }

    public static int GetDayOfWeek(Date date) {
        return date.dt.getDayOfWeek().getValue();
    }

    public static int GetDayOfYear(Date date) {
        return date.dt.getDayOfYear();
    }

    public static int GetWeekOfYear(Date date) {
        return date.dt.get(WeekFields.ISO.weekOfYear());
    }

    public static int GetHour(DateTime dateTime) {
        return dateTime.dt.getHour();
    }

    public static int GetMinute(DateTime dateTime) {
        return dateTime.dt.getMinute();
    }

    public static int GetSecond(DateTime dateTime) {
        return dateTime.dt.getSecond();
    }

    public static int GetMillisecond(DateTime dateTime) {
        return dateTime.dt.get(ChronoField.MILLI_OF_SECOND);
    }

    public static String GetTimeZone(Date date) {
        return date.tz;
    }

    public static DateTime AddDays(DateTime date, long days) {
        return date.addDays(days);
    }

    public static Date AddDays(Date date, long days) {
        return date.addDays(days);
    }

    public static DateTime AddMonths(DateTime date, long months) {
        return date.addMonths(months);
    }

    public static Date AddMonths(Date date, long months) {
        return date.addMonths(months);
    }

    public static DateTime AddYears(DateTime date, long years) {
        return date.addMonths(years);
    }

    public static Date AddYears(Date date, long years) {
        return date.addYears(years);
    }

    public static DateTime AddHours(DateTime date, long hours) {
        return date.addHours(hours);
    }

    public static DateTime AddMinutes(DateTime date, long minutes) {
        return date.addMinutes(minutes);
    }

    public static DateTime AddSeconds(DateTime date, long seconds) {
        return date.addSeconds(seconds);
    }

    public static DateTime AddMilliseconds(DateTime date, long milliseconds) {
        return date.addMilliseconds(milliseconds);
    }

    public static Date WithTimeZone(Date date, String timeZone) {
        return Functions.GetDate(Functions.GetYear(date), Functions.GetMonth(date), Functions.GetDay(date), timeZone);
    }

    public static Date InTimeZone(Date date, String timeZone) {
        return Functions.ToDate(new DateTime(date.dt.withZoneSameInstant(ZoneId.of(timeZone)), timeZone));
    }

    public static DateTime WithTimeZone(DateTime date, String timeZone) {
        return new DateTime(date.dt.withZoneSameLocal(ZoneId.of(timeZone)), timeZone);
    }

    public static DateTime InTimeZone(DateTime date, String timeZone) {
        return new DateTime(date.dt.withZoneSameInstant(ZoneId.of(timeZone)), timeZone);
    }

    public static boolean Before(Date before, Date after) {
        return before.dt.isBefore(after.dt);
    }

    public static boolean After(Date after, Date before) {
        return after.dt.isAfter(before.dt);
    }

    public static Date ToDate(DateTime dateTime) {
        return Functions.GetDate(dateTime.dt.getYear(), dateTime.dt.getMonthValue(), dateTime.dt.getDayOfMonth(), dateTime.dt.getZone().getId());
    }

    public static String FormatDate(Date date, String pattern) {
        try {
            return date.dt.format(DateTimeFormatter.ofPattern(pattern));
        }
        catch (IllegalArgumentException e) {
            throw new Comp1110WrappedException(e, AbortReason.DATE_PATTERN);
        }
    }

    public static Date ParseDate(String text, String pattern) {
        try {
            LocalDate dt = LocalDate.parse(text, DateTimeFormatter.ofPattern(pattern));
            return Functions.GetDate(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), ZoneId.systemDefault().getId());
        }
        catch (IllegalArgumentException e) {
            throw new Comp1110WrappedException(e, AbortReason.DATE_PATTERN);
        }
    }

    public static Date ParseDate(String text, String pattern, String timeZone) {
        try {
            LocalDate dt = LocalDate.parse(text, DateTimeFormatter.ofPattern(pattern));
            return Functions.GetDate(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), timeZone);
        }
        catch (IllegalArgumentException e) {
            throw new Comp1110WrappedException(e, AbortReason.DATE_PATTERN);
        }
    }

    public static DateTime ParseDateTime(String text, String pattern) {
        try {
            ZonedDateTime dt = ZonedDateTime.parse(text, DateTimeFormatter.ofPattern(pattern));
            return new DateTime(dt, dt.getZone().getId());
        }
        catch (IllegalArgumentException e) {
            throw new Comp1110WrappedException(e, AbortReason.DATE_PATTERN);
        }
    }

    public static long YearsBetween(Date date1, Date date2) {
        return ChronoUnit.YEARS.between(date1.dt, date2.dt);
    }

    public static long MonthsBetween(Date date1, Date date2) {
        return ChronoUnit.MONTHS.between(date1.dt, date2.dt);
    }

    public static long DaysBetween(Date date1, Date date2) {
        return ChronoUnit.DAYS.between(date1.dt, date2.dt);
    }

    public static long HoursBetween(Date date1, Date date2) {
        return ChronoUnit.HOURS.between(date1.dt, date2.dt);
    }

    public static long MinutesBetween(Date date1, Date date2) {
        return ChronoUnit.MINUTES.between(date1.dt, date2.dt);
    }

    public static long SecondsBetween(Date date1, Date date2) {
        return ChronoUnit.SECONDS.between(date1.dt, date2.dt);
    }

    public static long MillisecondsBetween(Date date1, Date date2) {
        return ChronoUnit.MILLIS.between(date1.dt, date2.dt);
    }

    public static <T, U, R> Function<T, Function<U, R>> Curry(BiFunction<T, U, R> fun) {
        return t -> u -> fun.apply(t, u);
    }

    public static <T, U, R> Function<Pair<T, U>, R> PairFunction(BiFunction<T, U, R> fun) {
        return p -> fun.apply(p.first(), p.second());
    }

    public static <T, U, R> BiFunction<T, U, R> UnpairFunction(Function<Pair<T, U>, R> fun) {
        return (t, u) -> fun.apply(new Pair<Object, Object>(t, u));
    }

    public static <T, U> Function<T, Predicate<U>> CurryPredicate(BiPredicate<T, U> p) {
        return t -> u -> p.test(t, u);
    }

    public static <T, U, R> BiFunction<T, U, R> UnCurryFunction(Function<T, Function<U, R>> fun) {
        return (t, u) -> ((Function)fun.apply(t)).apply(u);
    }

    public static <T, U> BiPredicate<T, U> UnCurryPredicate(Function<T, Predicate<U>> fun) {
        return (t, u) -> ((Predicate)fun.apply(t)).test(u);
    }

    public static <T, U, R> Function<T, R> Compose(Function<T, U> fun1, Function<U, R> fun2) {
        return t -> fun2.apply(fun1.apply(t));
    }

    public static <T> Predicate<T> ComposeAnd(Predicate<T> p1, Predicate<T> p2) {
        return t -> p1.test(t) && p2.test(t);
    }

    public static <T> Predicate<T> ComposeOr(Predicate<T> p1, Predicate<T> p2) {
        return t -> p1.test(t) || p2.test(t);
    }

    public static <T, U> BiPredicate<T, U> BiComposeAnd(Predicate<T> p1, Predicate<U> p2) {
        return (t, u) -> p1.test(t) && p2.test(u);
    }

    public static <T, U> BiPredicate<T, U> BiComposeOr(Predicate<T> p1, Predicate<U> p2) {
        return (t, u) -> p1.test(t) || p2.test(u);
    }

    public static <T> IntFunction<T> PrimitiveIntFunction(Function<Integer, T> intFun) {
        return intFun::apply;
    }

    public static <T> LongFunction<T> PrimitiveLongFunction(Function<Long, T> longFun) {
        return longFun::apply;
    }

    public static <T> DoubleFunction<T> PrimitiveDoubleFunction(Function<Double, T> doubleFun) {
        return doubleFun::apply;
    }

    public static <T> Predicate<T> PrimitivePredicate(Function<T, Boolean> booleanFunction) {
        return booleanFunction::apply;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static <T> Maybe<T> Join(Maybe<Maybe<T>> maybe) {
        v0 = maybe;
        Objects.requireNonNull(v0);
        var1_1 = v0;
        var2_3 = 0;
        block8: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nothing.class, Something.class, Something.class}, var1_1, var2_3)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: 
                case 1: {
                    if (!(var1_1 instanceof Nothing)) ** GOTO lbl14
                    var3_7 = (Nothing)var1_1;
                    ** GOTO lbl23
lbl14:
                    // 1 sources

                    if (!(var1_1 instanceof Something)) ** GOTO lbl-1000
                    var4_4 = (Something)var1_1;
                    var6_5 /* !! */  = (Maybe)var4_4.element();
                    if (var6_5 /* !! */  instanceof Nothing) {
                        var5_8 = (Nothing)var6_5 /* !! */ ;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var2_3 = 2;
                        continue block8;
                    }
lbl23:
                    // 2 sources

                    v1 /* !! */  = new Nothing<T>();
                    break block8;
                }
                case 2: {
                    var6_5 /* !! */  = (Something)var1_1;
                    var9_6 /* !! */  = (Maybe)var6_5 /* !! */ .element();
                    if (var9_6 /* !! */  instanceof Something) {
                        var7_9 = (Something)var9_6 /* !! */ ;
                        elem /* !! */  = var9_6 /* !! */  = var7_9.element();
                    } else {
                        var2_3 = 3;
                        continue block8;
                    }
                    v1 /* !! */  = new Something<Maybe>(elem /* !! */ );
                    break block8;
                }
            }
            break;
        }
        return v1 /* !! */ ;
        catch (Throwable var1_2) {
            throw new MatchException(var1_2.toString(), var1_2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T> Maybe<T> Bind(Maybe<S> maybe, Function<S, Maybe<T>> fun) {
        Maybe maybe2;
        Maybe<S> maybe3 = maybe;
        Objects.requireNonNull(maybe3);
        Maybe<S> maybe32 = maybe3;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nothing.class, Something.class}, maybe32, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nothing nothing = (Nothing)maybe32;
                maybe2 = new Nothing();
                return maybe2;
            }
            case 1: 
        }
        Something something = (Something)maybe32;
        try {
            Object t;
            Object elem = t = something.element();
            maybe2 = fun.apply(elem);
            return maybe2;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S, T> Maybe<T> Map(Maybe<S> maybe, Function<S, T> fun) {
        Record record;
        Maybe<S> maybe2 = maybe;
        Objects.requireNonNull(maybe2);
        Maybe<S> maybe3 = maybe2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nothing.class, Something.class}, maybe3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nothing nothing = (Nothing)maybe3;
                record = new Nothing();
                return record;
            }
            case 1: 
        }
        Something something = (Something)maybe3;
        try {
            Object t;
            Object elem = t = something.element();
            record = new Something(fun.apply(elem));
            return record;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T Default(Maybe<T> maybe, T defaultValue) {
        T t;
        Maybe<T> maybe2 = maybe;
        Objects.requireNonNull(maybe2);
        Maybe<T> maybe3 = maybe2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nothing.class, Something.class}, maybe3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nothing nothing = (Nothing)maybe3;
                t = defaultValue;
                return t;
            }
            case 1: 
        }
        Something something = (Something)maybe3;
        try {
            Object t2;
            Object elem = t2 = something.element();
            t = elem;
            return t;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @SafeVarargs
    public static <K, V> ConsList<Pair<K, V>> MakeConsMap(Pair<K, V> ... keyValuePairs) {
        ConsList<Pair<K, V>> ret = new Nil<Pair<K, V>>();
        for (int i = keyValuePairs.length - 1; i >= 0; --i) {
            ret = Functions.Put(ret, keyValuePairs[i].first(), keyValuePairs[i].second());
        }
        return ret;
    }

    public static <K, V> ConsList<Pair<K, V>> Put(ConsList<Pair<K, V>> map, K key, V value) {
        return new Cons<Pair<K, V>>(new Pair<K, V>(key, value), Functions.Remove(map, key));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V> ConsList<Pair<K, V>> Remove(ConsList<Pair<K, V>> map, K key) {
        Object rest;
        Pair first;
        Object object;
        ConsList<Pair<K, V>> consList;
        ConsList<Pair<K, V>> consList2 = map;
        Objects.requireNonNull(consList2);
        ConsList<Pair<K, V>> consList22 = consList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList22, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList22;
                consList = new Nil<Pair<K, V>>();
                return consList;
            }
            case 1: 
        }
        Cons cons = (Cons)consList22;
        try {
            object = (Pair)cons.element();
            first = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        {
            rest = object = cons.rest();
        }
        if (Functions.Equals(first.first(), key)) {
            consList = Functions.Remove(rest, key);
            return consList;
        }
        consList = new Cons<Pair<K, V>>(first, Functions.Remove(rest, key));
        return consList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <K, V> Maybe<V> Get(ConsList<Pair<K, V>> map, K key) {
        Object rest;
        Pair first;
        Object object;
        Maybe<Object> maybe;
        ConsList<Pair<K, V>> consList = map;
        Objects.requireNonNull(consList);
        ConsList<Pair<K, V>> consList2 = consList;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Nil.class, Cons.class}, consList2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Nil nil = (Nil)consList2;
                maybe = new Nothing();
                return maybe;
            }
            case 1: 
        }
        Cons cons = (Cons)consList2;
        try {
            object = (Pair)cons.element();
            first = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        {
            rest = object = cons.rest();
        }
        if (Functions.Equals(first.first(), key)) {
            maybe = new Something(first.second());
            return maybe;
        }
        maybe = Functions.Get(rest, key);
        return maybe;
    }

    public static <K, V> boolean ContainsKey(ConsList<Pair<K, V>> map, K key) {
        return Functions.Default(Functions.Map(Functions.Get(map, key), (S x) -> true), false);
    }

    public static <K, V> ConsList<K> GetKeys(ConsList<Pair<K, V>> map) {
        return Functions.Unzip(map).first();
    }

    @SafeVarargs
    public static <K, V> Map<K, V> MakeHashMap(Pair<K, V> ... keyValuePairs) {
        HashMap<K, V> ret = new HashMap<K, V>(keyValuePairs.length);
        for (int i = keyValuePairs.length - 1; i >= 0; --i) {
            ret.put(keyValuePairs[i].first(), keyValuePairs[i].second());
        }
        return ret;
    }

    public static <K, V> void Put(Map<K, V> map, K key, V value) {
        map.put(key, value);
    }

    public static <K, V> Maybe<V> Get(Map<K, V> map, K key) {
        if (map.containsKey(key)) {
            return new Something<V>(map.get(key));
        }
        return new Nothing();
    }

    public static <K, V> void Remove(Map<K, V> map, K key) {
        map.remove(key);
    }

    public static <K, V> boolean ContainsKey(Map<K, V> map, K key) {
        return map.containsKey(key);
    }

    public static <K, V> ConsList<K> GetKeys(Map<K, V> map) {
        return Functions.MakeList(map.keySet());
    }

    static {
        origUEH = Thread.getDefaultUncaughtExceptionHandler();
        Functions.SetComp1110ErrorHandler();
        comp1110UnitExceptions = new ArrayList<String>();
        comp1110UnitExceptions.add("comp1110.testing.Comp1110Unit.runAsTest");
        compatibleVersions = new String[]{"2025S1-3", "2025S1-4", "2025S1-5", "2025S1-6", "2025S1-7"};
    }

    private static enum AbortReason {
        DEFAULT,
        DATE_PATTERN;

    }

    private static class Comp1110WrappedException
    extends RuntimeException {
        public final AbortReason reason;

        public Comp1110WrappedException(Throwable throwable, AbortReason reason) {
            super(throwable.getMessage(), throwable);
            this.reason = reason;
        }
    }

    private static class Comp1110LibException
    extends RuntimeException {
        public Comp1110LibException(String message) {
            super(message);
            this.setStackTrace(Functions.RemoveUntilPrefixFromStackTrace(this.getStackTrace(), "comp1110.lib.", comp1110UnitExceptions));
        }
    }
}

