/*
 * Decompiled with CFR 0.152.
 */
package comp1110.testing;

import comp1110.lib.Functions;
import java.util.concurrent.atomic.AtomicLong;

public class Comp1110Unit {
    public static double EPSILON = 1.0E-9;
    private static volatile long runTestFunctions = 0L;
    private static volatile long passedTestFunctions = 0L;
    private static final AtomicLong passedTests = new AtomicLong(0L);
    private static final AtomicLong runTests = new AtomicLong(0L);
    private static final Object testLock;

    public static long getPassedTests() {
        return passedTests.get();
    }

    public static long getRunTests() {
        return runTests.get();
    }

    private static String nullString(Object o) {
        if (o != null) {
            return o.toString();
        }
        return "[null]";
    }

    private static String getTopStackTraceString() {
        try {
            throw new Comp1110UnitException();
        }
        catch (Comp1110UnitException e) {
            StackTraceElement ste = Comp1110Unit.getTopStackTraceElement(e.getStackTrace());
            if (ste != null) {
                return ste.toString();
            }
            return "Unknown Location";
        }
    }

    private static StackTraceElement getTopStackTraceElement(StackTraceElement[] arr) {
        for (StackTraceElement ste : arr) {
            if (ste.getClassName().equals("comp1110.testing.Comp1110Unit")) continue;
            return ste;
        }
        return null;
    }

    private static String assembleMessage(String msg, StackTraceElement ste, Object ... args) {
        StringBuilder sb = new StringBuilder();
        int curIndex = 0;
        int nextIndex = msg.indexOf(36, curIndex);
        while (nextIndex >= 0) {
            if (nextIndex + 1 < msg.length() && msg.charAt(nextIndex + 1) == '$') {
                sb.append(msg, curIndex, nextIndex + 2);
                curIndex = nextIndex + 2;
            } else {
                sb.append(msg, curIndex, nextIndex);
                for (nextIndex = curIndex = nextIndex + 1; nextIndex < msg.length() && Character.isDigit(msg.charAt(nextIndex)); ++nextIndex) {
                }
                if (nextIndex > curIndex && nextIndex < msg.length() && msg.charAt(nextIndex) == ';') {
                    int idx = Integer.parseInt(msg, curIndex, nextIndex, 10);
                    if (idx < args.length) {
                        sb.append(Comp1110Unit.nullString(args[idx]));
                    } else {
                        sb.append("[Invalid argument id given at index ");
                        sb.append(curIndex);
                        sb.append(": ");
                        sb.append(idx);
                        sb.append(" - expected value between 0 (inclusive) and ");
                        sb.append(args.length);
                        sb.append(" (exclusive)]");
                    }
                    curIndex = nextIndex + 1;
                } else {
                    if (nextIndex == curIndex) {
                        sb.append("[ERROR: expected numeric argument id at index");
                        sb.append(curIndex);
                        sb.append(" - to use $ sign on its own, write $$]");
                    } else if (nextIndex >= msg.length() || msg.charAt(nextIndex) != ';') {
                        sb.append("[ERROR: expected argument identifier terminated by semicolon (';') at index ");
                        sb.append(curIndex);
                        if (nextIndex < msg.length()) {
                            sb.append(" - found '");
                            sb.append(msg.charAt(nextIndex));
                            sb.append("']");
                        } else {
                            sb.append(", but String ended prematurely]");
                        }
                    }
                    curIndex = nextIndex + 1;
                }
            }
            nextIndex = msg.indexOf(36, curIndex);
        }
        if (curIndex < msg.length()) {
            sb.append(msg, curIndex, msg.length());
        }
        if (ste != null) {
            sb.append(" [");
            sb.append(ste);
            sb.append("]");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runAsTest(Runnable testFunction) {
        Object object = testLock;
        synchronized (object) {
            try {
                System.err.println("Running Test #" + ++runTestFunctions);
                runTests.set(0L);
                passedTests.set(0L);
                testFunction.run();
                if (runTests.get() == passedTests.get()) {
                    ++passedTestFunctions;
                    System.err.println("Test #" + runTestFunctions + " succeeded!");
                } else {
                    System.err.println("Test #" + runTestFunctions + " failed!");
                }
            }
            catch (Throwable t) {
                Functions.ExplainException(t);
                System.err.println("Test #" + runTestFunctions + " failed!");
            }
        }
    }

    public static void testEqual(Object o1, Object o2) {
        Comp1110Unit.testEqual(o1, o2, "$0; and $1; are not equal!");
    }

    public static void testEqual(Object o1, Object o2, String message) {
        runTests.incrementAndGet();
        try {
            long lo2;
            long lo1;
            if (o1 == null) {
                if (o2 == null) {
                    passedTests.incrementAndGet();
                    return;
                }
                throw new Comp1110UnitException();
            }
            if (o2 == null) {
                throw new Comp1110UnitException();
            }
            if (o1.equals(o2)) {
                passedTests.incrementAndGet();
                return;
            }
            if ((o1 instanceof Double || o1 instanceof Float) && (o2 instanceof Double || o2 instanceof Float) && Math.abs((Double)o1 - (Double)o2) < EPSILON) {
                passedTests.incrementAndGet();
                return;
            }
            if ((o1 instanceof Long || o1 instanceof Integer) && (o2 instanceof Long || o2 instanceof Integer) && (lo1 = o1 instanceof Long ? (Long)o1 : (long)((Integer)o1).intValue()) == (lo2 = o2 instanceof Long ? (Long)o2 : (long)((Integer)o2).intValue())) {
                passedTests.incrementAndGet();
                return;
            }
            throw new Comp1110UnitException();
        }
        catch (Comp1110UnitException e) {
            StackTraceElement ste = Comp1110Unit.getTopStackTraceElement(e.getStackTrace());
            String msg = Comp1110Unit.assembleMessage(message, ste, o1, o2);
            System.err.println(msg);
            System.err.flush();
        }
        catch (Exception e) {
            System.err.println("Tried to compare " + Comp1110Unit.nullString(o1) + " and " + Comp1110Unit.nullString(o2) + " at " + Comp1110Unit.getTopStackTraceString() + ",\nbut caught " + e.getClass().getName() + ":\n" + e.getMessage());
            Functions.ExplainException(e);
        }
    }

    public static void testNotEqual(Object o1, Object o2) {
        Comp1110Unit.testNotEqual(o1, o2, "$0; and $1; are equal!");
    }

    public static void testNotEqual(Object o1, Object o2, String message) {
        runTests.incrementAndGet();
        try {
            long lo2;
            long lo1;
            if (o1 == null) {
                if (o2 == null) {
                    throw new Comp1110UnitException();
                }
                passedTests.incrementAndGet();
                return;
            }
            if (o2 == null) {
                passedTests.incrementAndGet();
                return;
            }
            if (o1.equals(o2)) {
                throw new Comp1110UnitException();
            }
            if ((o1 instanceof Double || o1 instanceof Float) && (o2 instanceof Double || o2 instanceof Float) && Math.abs((Double)o1 - (Double)o2) < EPSILON) {
                throw new Comp1110UnitException();
            }
            if ((o1 instanceof Long || o1 instanceof Integer) && (o2 instanceof Long || o2 instanceof Integer) && (lo1 = o1 instanceof Long ? (Long)o1 : (long)((Integer)o1).intValue()) == (lo2 = o2 instanceof Long ? (Long)o2 : (long)((Integer)o2).intValue())) {
                throw new Comp1110UnitException();
            }
            passedTests.incrementAndGet();
            return;
        }
        catch (Comp1110UnitException e) {
            StackTraceElement ste = Comp1110Unit.getTopStackTraceElement(e.getStackTrace());
            String msg = Comp1110Unit.assembleMessage(message, ste, o1, o2);
            System.err.println(msg);
            System.err.flush();
        }
        catch (Exception e) {
            System.err.println("Tried to compare " + Comp1110Unit.nullString(o1) + " and " + Comp1110Unit.nullString(o2) + " at " + Comp1110Unit.getTopStackTraceString() + ",\nbut caught " + e.getClass().getName() + ":\n" + e.getMessage());
            Functions.ExplainException(e);
        }
    }

    public static void testTrue(boolean b) {
        Comp1110Unit.testTrue(b, "Expected true, but got false!");
    }

    public static void testTrue(boolean b, String message) {
        runTests.incrementAndGet();
        try {
            if (b) {
                passedTests.incrementAndGet();
                return;
            }
            throw new Comp1110UnitException();
        }
        catch (Comp1110UnitException e) {
            StackTraceElement ste = Comp1110Unit.getTopStackTraceElement(e.getStackTrace());
            String msg = Comp1110Unit.assembleMessage(message, ste, new Object[0]);
            System.err.println(msg);
            System.err.flush();
        }
        catch (Exception e) {
            System.err.println("Tried to check that " + b + " is true at " + Comp1110Unit.getTopStackTraceString() + ",\nbut caught " + e.getClass().getName() + ":\n" + e.getMessage());
            Functions.ExplainException(e);
        }
    }

    public static void testFalse(boolean b) {
        Comp1110Unit.testFalse(b, "Expected false, but got true!");
    }

    public static void testFalse(boolean b, String message) {
        runTests.incrementAndGet();
        try {
            if (!b) {
                passedTests.incrementAndGet();
                return;
            }
            throw new Comp1110UnitException();
        }
        catch (Comp1110UnitException e) {
            StackTraceElement ste = Comp1110Unit.getTopStackTraceElement(e.getStackTrace());
            String msg = Comp1110Unit.assembleMessage(message, ste, new Object[0]);
            System.err.println(msg);
            System.err.flush();
        }
        catch (Exception e) {
            System.err.println("Tried to check that " + b + " is false at " + Comp1110Unit.getTopStackTraceString() + ",\nbut caught " + e.getClass().getName() + ":\n" + e.getMessage());
            Functions.ExplainException(e);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        testLock = new Object();
    }

    private static class Comp1110UnitException
    extends Exception {
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            if (runTestFunctions > 0L) {
                System.err.println("Passed " + passedTestFunctions + " / " + runTestFunctions + " tests");
            } else if (runTests.get() > 0L) {
                System.err.println("Passed " + passedTests.get() + " / " + runTests.get() + " tests");
            }
        }
    }
}

