/*
 * Decompiled with CFR 0.152.
 */
package comp1110.testing;

import comp1110.testing.Comp1110Unit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class Test {
    public static void main(String[] args) {
        Class<?> mclass;
        URLClassLoader loader;
        String mainfile = "Main.java";
        ArrayList<File> cps = new ArrayList<File>();
        ArrayList<File> existingClassFiles = new ArrayList<File>();
        boolean compile = true;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--nocompile")) {
                compile = false;
                continue;
            }
            if (args[i].equals("--cp")) {
                if (i + 1 < args.length) {
                    cps.add(new File(args[i + 1]));
                    ++i;
                    continue;
                }
                System.out.println("--cp needs additional parameter!");
                System.exit(1);
                continue;
            }
            mainfile = args[i];
        }
        if (!mainfile.endsWith(".java")) {
            System.out.println("Invalid file argument: '" + mainfile + "'. Must be a java file!");
            return;
        }
        File codefile = new File(mainfile);
        if (!codefile.exists()) {
            System.out.println("'" + mainfile + "' does not exist!");
            return;
        }
        File dir = codefile.getAbsoluteFile().getParentFile();
        try {
            URL[] cp = new URL[]{dir.toURI().toURL()};
            if (!cps.isEmpty()) {
                cp = new URL[cps.size()];
                for (int i = 0; i < cps.size(); ++i) {
                    cp[i] = ((File)cps.get(i)).toURI().toURL();
                }
            }
            loader = new URLClassLoader(cp, ClassLoader.getSystemClassLoader());
        }
        catch (MalformedURLException e) {
            System.out.println("Testing framework encountered internal error. See error information below.\n");
            System.out.println(e.getClass().getName() + ": " + e.getMessage() + "\n");
            e.printStackTrace();
            return;
        }
        if (!dir.isDirectory() || !dir.exists()) {
            System.out.println("Testing framework encountered internal error: '" + dir.getAbsolutePath() + "' is not a directory or does not exist!");
            return;
        }
        File[] files1 = dir.listFiles(pathname -> pathname.getName().substring(pathname.getName().lastIndexOf(46) + 1).equals("java"));
        if (files1 == null) {
            System.out.println("Testing framework encountered internal error: '" + dir.getAbsolutePath() + "' is not a directory or does not exist!");
            return;
        }
        boolean found = false;
        for (File f : files1) {
            if (!f.getName().equals(mainfile)) continue;
            found = true;
            break;
        }
        if (!found) {
            System.out.println("'" + mainfile + "' not found!");
            return;
        }
        if (compile) {
            for (File f : dir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".class")) continue;
                existingClassFiles.add(f);
            }
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(files1));
            boolean allOk = true;
            for (JavaFileObject javaFileObject : compilationUnits1) {
                File source = new File(javaFileObject.getName());
                File clsfile = new File(javaFileObject.getName().substring(0, javaFileObject.getName().length() - 5) + ".class");
                if (!source.exists() || clsfile.exists() && clsfile.lastModified() >= source.lastModified()) continue;
                allOk = false;
            }
            if (!allOk) {
                LinkedList<String> options = new LinkedList<String>();
                options.add("--enable-preview");
                options.add("-source");
                options.add("23");
                if (!compiler.getTask(null, fileManager, null, options, null, compilationUnits1).call().booleanValue()) {
                    System.out.println("Unable to compile Java sources. Please make sure that all Java files in this folder can be compiled together.");
                }
            }
            try {
                fileManager.close();
            }
            catch (IOException e) {
                System.out.println("Testing framework encountered internal error. See error information below.\n");
                System.out.println(e.getClass().getName() + ": " + e.getMessage() + "\n");
                e.printStackTrace();
                return;
            }
            for (File f : dir.listFiles()) {
                if (!f.isFile() || !f.getName().endsWith(".class") || existingClassFiles.contains(f)) continue;
                f.deleteOnExit();
            }
        }
        try {
            mclass = loader.loadClass(mainfile.substring(0, mainfile.length() - 5));
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not find '" + mainfile + "'!");
            return;
        }
        found = false;
        for (Method method : mclass.getDeclaredMethods()) {
            if (!method.getName().equals("test")) continue;
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    method.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println("Testing framework encountered error: static 'test' method could not be called!");
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.out.println("Static 'test' method threw " + invocationTargetException.getTargetException().getClass().getName() + ": " + invocationTargetException.getTargetException().getMessage() + "\n");
                    invocationTargetException.getTargetException().printStackTrace();
                    return;
                }
            }
            try {
                Constructor<?> constructor = mclass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                Object instance = constructor.newInstance(new Object[0]);
                try {
                    method.invoke(instance, new Object[0]);
                }
                catch (IllegalAccessException e) {
                    System.out.println("Testing framework encountered error: 'test' method could not be called!");
                }
                catch (InvocationTargetException e) {
                    System.out.println("'test' method threw " + e.getTargetException().getClass().getName() + ": " + e.getTargetException().getMessage() + "\n");
                    e.getTargetException().printStackTrace();
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                System.out.println("Testing framework encountered error: '" + mclass.getName() + "' object could not be instantiated!");
            }
            catch (InvocationTargetException invocationTargetException) {
                System.out.println("'" + mclass.getName() + "' class constructor threw " + invocationTargetException.getTargetException().getClass().getName() + ": " + invocationTargetException.getTargetException().getMessage() + "\n");
                invocationTargetException.getTargetException().printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                System.out.println("Testing framework encountered error: could not create instance of " + mclass.getName() + " class with empty constructor!");
                return;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                System.out.println("Testing framework encountered error: " + mclass.getName() + " class constructor not found!");
                noSuchMethodException.printStackTrace();
            }
            if (Comp1110Unit.getRunTests() > 0L && Comp1110Unit.getPassedTests() < Comp1110Unit.getRunTests()) {
                System.exit(1);
            }
            found = true;
            break;
        }
        if (!found) {
            System.out.println("Did not find method " + mclass.getName() + ".test()");
            System.exit(1);
        }
    }
}

