/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Functions;
import comp1110.universe.Image;
import comp1110.universe.Mode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

class Ellipse
extends Image {
    final Mode mode;
    final Color color;

    Ellipse(int radius, Mode mode, Color color) {
        Area area = new Area(new Ellipse2D.Double(-radius, -radius, 2 * radius, 2 * radius));
        super(area);
        this.mode = mode;
        this.color = color;
    }

    Ellipse(int width, int height, Mode mode, Color color) {
        Area area = new Area(new Ellipse2D.Double((double)(-width) / 2.0, (double)(-height) / 2.0, width, height));
        super(area);
        this.mode = mode;
        this.color = color;
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.setColor(this.color);
        switch (this.mode) {
            case OUTLINE: {
                graphics.drawOval(Functions.RoundInt(this.bounds.getX()), Functions.RoundInt(this.bounds.getY()), Functions.RoundInt(this.bounds.getWidth()), Functions.RoundInt(this.bounds.getHeight()));
                break;
            }
            case SOLID: {
                graphics.fillOval(Functions.RoundInt(this.bounds.getX()), Functions.RoundInt(this.bounds.getY()), Functions.RoundInt(this.bounds.getWidth()), Functions.RoundInt(this.bounds.getHeight()));
            }
        }
    }
}

