/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Comp1110Exception;
import comp1110.lib.ConsList;
import comp1110.lib.Functions;
import comp1110.lib.Pair;
import comp1110.universe.Colour;
import comp1110.universe.Ellipse;
import comp1110.universe.FontStyle;
import comp1110.universe.ImageCombination;
import comp1110.universe.ImageImage;
import comp1110.universe.ImageOverlay;
import comp1110.universe.ImagePlace;
import comp1110.universe.ImageTranslate;
import comp1110.universe.Line;
import comp1110.universe.MaskedImage;
import comp1110.universe.Mode;
import comp1110.universe.Polygon;
import comp1110.universe.Rectangle;
import comp1110.universe.RotatedImage;
import comp1110.universe.ScaledImage;
import comp1110.universe.Text;
import comp1110.universe.TextAlign;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public abstract class Image {
    private static String text;
    final Area area;
    final Rectangle2D bounds;

    Image(Area area) {
        this.area = area;
        this.bounds = area.getBounds2D();
    }

    Image overlay(Image other) {
        ArrayList<ImageCombination.ImagePlacement> lst = new ArrayList<ImageCombination.ImagePlacement>();
        lst.add(new ImageCombination.ImagePlacement(other, 0, 0));
        return new ImageOverlay(this, lst);
    }

    Image overlayXY(Image other, int x, int y) {
        ArrayList<ImageCombination.ImagePlacement> lst = new ArrayList<ImageCombination.ImagePlacement>();
        lst.add(new ImageCombination.ImagePlacement(other, x + Functions.RoundInt(this.area.getBounds2D().getX()), y + Functions.RoundInt(this.area.getBounds2D().getY())));
        return new ImageOverlay(this, lst);
    }

    Image place(Image other) {
        ArrayList<ImageCombination.ImagePlacement> lst = new ArrayList<ImageCombination.ImagePlacement>();
        lst.add(new ImageCombination.ImagePlacement(other, 0, 0));
        return new ImagePlace(this, lst);
    }

    Image placeXY(Image other, int x, int y) {
        ArrayList<ImageCombination.ImagePlacement> lst = new ArrayList<ImageCombination.ImagePlacement>();
        lst.add(new ImageCombination.ImagePlacement(other, x + Functions.RoundInt(this.area.getBounds2D().getX()), y + Functions.RoundInt(this.area.getBounds2D().getY())));
        return new ImagePlace(this, lst);
    }

    Image translate(int x, int y) {
        return new ImageTranslate(this, x, y);
    }

    abstract void draw(Graphics2D var1);

    Area getArea() {
        return this.area;
    }

    public static boolean Intersects(Image image1, int x1, int y1, Image image2, int x2, int y2) {
        Area area = image1.area.createTransformedArea(AffineTransform.getTranslateInstance(x1, y1));
        area.intersect(image2.area.createTransformedArea(AffineTransform.getTranslateInstance(x2, y2)));
        return !area.isEmpty();
    }

    public static int GetImageWidth(Image image) {
        return Functions.RoundInt(image.getArea().getBounds2D().getWidth());
    }

    public static int GetImageHeight(Image image) {
        return Functions.RoundInt(image.getArea().getBounds2D().getHeight());
    }

    public static int GetImagePinX(Image image) {
        return -Functions.RoundInt(image.getArea().getBounds2D().getX());
    }

    public static int GetImagePinY(Image image) {
        return -Functions.RoundInt(image.getArea().getBounds2D().getY());
    }

    public static Image MovePinBy(Image image, int x, int y) {
        return image.translate(-x, -y);
    }

    public static Image MovePinTo(Image image, int x, int y) {
        return new ImageTranslate(image, -Functions.RoundInt(image.bounds.getX()) - x, -Functions.RoundInt(image.bounds.getY()) - y);
    }

    public static Image AlignPinLeft(Image image) {
        return image.translate(-Functions.RoundInt(image.bounds.getX()), 0);
    }

    public static Image AlignPinRight(Image image) {
        return image.translate(-Functions.RoundInt(image.bounds.getWidth() + image.bounds.getX()), 0);
    }

    public static Image AlignPinCenter(Image image) {
        return image.translate(-Functions.RoundInt(image.bounds.getWidth() / 2.0 + image.bounds.getX()), 0);
    }

    public static Image AlignPinTop(Image image) {
        return image.translate(0, -Functions.RoundInt(image.bounds.getY()));
    }

    public static Image AlignPinBottom(Image image) {
        return image.translate(0, -Functions.RoundInt(image.bounds.getHeight() + image.bounds.getY()));
    }

    public static Image AlignPinMiddle(Image image) {
        return image.translate(0, -Functions.RoundInt(image.bounds.getHeight() / 2.0 + image.bounds.getY()));
    }

    public static Image Rectangle(int width, int height, Colour color) {
        return Image.Rectangle(width, height, color, Mode.SOLID);
    }

    public static Image Rectangle(int width, int height, Colour color, Mode mode) {
        return new Rectangle(width, height, width / 2, height / 2, mode, color.toColor());
    }

    public static Image Circle(int radius, Colour color) {
        return Image.Circle(radius, color, Mode.SOLID);
    }

    public static Image Circle(int radius, Colour color, Mode mode) {
        return new Ellipse(radius, mode, color.toColor());
    }

    public static Image Ellipse(int width, int height, Colour color) {
        return Image.Ellipse(width, height, color, Mode.SOLID);
    }

    public static Image Ellipse(int width, int height, Colour color, Mode mode) {
        return new Ellipse(width, height, mode, color.toColor());
    }

    @SafeVarargs
    public static Image Polygon(Colour colour, Pair<Integer, Integer> ... points) {
        return Image.Polygon(colour, Mode.SOLID, points);
    }

    public static Image Polygon(Colour colour, ConsList<Pair<Integer, Integer>> points) {
        return Image.Polygon(colour, Mode.SOLID, points);
    }

    @SafeVarargs
    public static Image Polygon(Colour colour, Mode mode, Pair<Integer, Integer> ... points) {
        return new Polygon(colour.toColor(), mode, points);
    }

    public static Image Polygon(Colour colour, Mode mode, ConsList<Pair<Integer, Integer>> points) {
        return new Polygon(colour.toColor(), mode, points);
    }

    public static Image Text(String text, String fontName, FontStyle style, int fontSize, Colour color) {
        return Image.Text(text, fontSize, -1, color, fontName, style);
    }

    public static Image Text(String text, int fontSize) {
        return Image.Text(text, fontSize, -1, Colour.BLACK, "Arial", FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, int maxWidth) {
        return Image.Text(text, fontSize, maxWidth, Colour.BLACK, "Arial", FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, Colour color) {
        return Image.Text(text, fontSize, -1, color, "Arial", FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, int maxWidth, Colour color) {
        return Image.Text(text, fontSize, maxWidth, color, "Arial", FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, Colour color, String fontName) {
        return Image.Text(text, fontSize, -1, color, fontName, FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, int maxWidth, Colour color, String fontName) {
        return Image.Text(text, fontSize, maxWidth, color, fontName, FontStyle.PLAIN);
    }

    public static Image Text(String text, int fontSize, Colour color, String fontName, FontStyle style) {
        return Image.Text(text, fontSize, -1, color, fontName, style);
    }

    public static Image Text(String text, int fontSize, int maxWidth, Colour color, String fontName, FontStyle style) {
        return new Text(text, maxWidth, fontName, style, fontSize, color.toColor(), TextAlign.DEFAULT);
    }

    public static Image Text(String text, int fontSize, Colour color, String fontName, FontStyle style, TextAlign align) {
        return Image.Text(text, fontSize, -1, color, fontName, style, align);
    }

    public static Image Text(String text, int fontSize, int maxWidth, Colour color, String fontName, FontStyle style, TextAlign align) {
        return new Text(text, maxWidth, fontName, style, fontSize, color.toColor(), align);
    }

    public static Image FromFile(String path) {
        File file = new File(path);
        if (!file.exists()) {
            throw new Comp1110Exception("File '" + path + "' does not exist!");
        }
        try {
            return new ImageImage(ImageIO.read(file));
        }
        catch (IOException e) {
            throw new Comp1110Exception("Error when trying to load image file '" + path + "': " + e.getMessage());
        }
    }

    public static void SavePNG(Image image, String path) {
        File file = new File(path);
        if (file.exists() && !file.delete()) {
            throw new Comp1110Exception("File '" + path + "' already exists and could not be deleted!");
        }
        BufferedImage bi = new BufferedImage(Functions.CeilInt(image.bounds.getWidth()), Functions.CeilInt(image.bounds.getHeight()), 2);
        Graphics2D graphics = bi.createGraphics();
        image.draw(graphics);
        try {
            ImageIO.write((RenderedImage)bi, "PNG", file);
        }
        catch (IOException e) {
            throw new Comp1110Exception("Could not save image to PNG at path '" + path + "': " + e.getMessage());
        }
    }

    public static void SaveJPEG(Image image, String path) {
        File file = new File(path);
        if (file.exists() && !file.delete()) {
            throw new Comp1110Exception("File '" + path + "' already exists and could not be deleted!");
        }
        BufferedImage bi = new BufferedImage(Functions.CeilInt(image.bounds.getWidth()), Functions.CeilInt(image.bounds.getHeight()), 2);
        Graphics2D graphics = bi.createGraphics();
        image.draw(graphics);
        try {
            ImageIO.write((RenderedImage)bi, "JPEG", file);
        }
        catch (IOException e) {
            throw new Comp1110Exception("Could not save image to JPEG at path '" + path + "': " + e.getMessage());
        }
    }

    public static Image DrawLine(Image base, int x1, int y1, int x2, int y2, Colour color) {
        return Image.DrawLine(base, x1, y1, x2, y2, color, 1);
    }

    public static Image DrawLine(Image base, int x1, int y1, int x2, int y2, Colour color, int thickness) {
        return new Line(base, x1, y1, x2, y2, color.toColor(), thickness);
    }

    public static Image Overlay(Image base, Image top) {
        return base.overlay(top);
    }

    public static Image OverlayXY(Image base, Image top, int x, int y) {
        return base.overlayXY(top, x, y);
    }

    public static Image Place(Image base, Image placed) {
        return base.place(placed);
    }

    public static Image PlaceXY(Image base, Image placed, int x, int y) {
        return base.placeXY(placed, x, y);
    }

    public static Image Rotate(Image image, double radians) {
        if (image instanceof RotatedImage) {
            return new RotatedImage(((RotatedImage)image).image, ((RotatedImage)image).theta + radians);
        }
        return new RotatedImage(image, radians);
    }

    public static Image Scale(Image image, double scale) {
        if (image instanceof ScaledImage) {
            return new ScaledImage(((ScaledImage)image).image, ((ScaledImage)image).sx + scale, ((ScaledImage)image).sy + scale);
        }
        return new ScaledImage(image, scale, scale);
    }

    public static Image ScaleX(Image image, double scale) {
        if (image instanceof ScaledImage) {
            return new ScaledImage(((ScaledImage)image).image, ((ScaledImage)image).sx + scale, ((ScaledImage)image).sy);
        }
        return new ScaledImage(image, scale, 1.0);
    }

    public static Image ScaleY(Image image, double scale) {
        if (image instanceof ScaledImage) {
            return new ScaledImage(((ScaledImage)image).image, ((ScaledImage)image).sx, ((ScaledImage)image).sy + scale);
        }
        return new ScaledImage(image, 1.0, scale);
    }

    public static Image Mask(Image image, Image mask) {
        return new MaskedImage(image, mask.getArea());
    }

    public static void ShowImage(Image image) {
        new ImageShow("Image", image);
    }

    public static void ShowImage(Image image, String title) {
        new ImageShow(title, image);
    }

    private static class ImageShow
    extends JPanel {
        private final JFrame frame;
        private final Image image;

        public ImageShow(String name, Image image) {
            this.frame = new JFrame(name);
            this.image = image;
            this.setSize(Functions.RoundInt(image.bounds.getWidth()), Functions.RoundInt(image.bounds.getHeight()));
            this.revalidate();
            this.frame.add(this);
            this.frame.pack();
            this.frame.setVisible(true);
            this.setVisible(true);
            this.repaint();
            this.frame.requestFocus();
            this.frame.setDefaultCloseOperation(2);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setClip(null);
            g.translate(-Functions.RoundInt(this.image.bounds.getX()), -Functions.RoundInt(this.image.bounds.getY()));
            g.clearRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
            this.image.draw((Graphics2D)g);
        }

        @Override
        public int getWidth() {
            return Functions.RoundInt(this.image.bounds.getWidth());
        }

        @Override
        public int getHeight() {
            return Functions.RoundInt(this.image.bounds.getHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getWidth(), this.getHeight());
        }

        @Override
        public boolean isValidateRoot() {
            return true;
        }
    }
}

