/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.universe.Image;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.List;

abstract class ImageCombination
extends Image {
    protected final Image baseImage;
    protected final List<ImagePlacement> images;

    ImageCombination(Image baseImage, Area area, List<ImagePlacement> images) {
        super(area);
        this.baseImage = baseImage;
        this.images = images;
    }

    ImageCombination(Image fromImage) {
        this(fromImage, fromImage.getArea(), new ArrayList<ImagePlacement>());
    }

    @Override
    Image overlay(Image other) {
        return this.overlayXY(other, 0, 0);
    }

    @Override
    Image place(Image other) {
        return this.placeXY(other, 0, 0);
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.clip(this.area);
        Shape clip = graphics.getClip();
        this.baseImage.draw(graphics);
        for (ImagePlacement i : this.images) {
            graphics.setClip(clip);
            graphics.translate(i.x(), i.y());
            i.image().draw(graphics);
            graphics.translate(-i.x(), -i.y());
        }
    }

    record ImagePlacement(Image image, int x, int y) {
        Area getArea() {
            return this.image.getArea().createTransformedArea(AffineTransform.getTranslateInstance(this.x, this.y));
        }
    }
}

