/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.universe.Image;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public class ImageTranslate
extends Image {
    final Image image;
    final int translationX;
    final int translationY;

    public ImageTranslate(Image image, int translationX, int translationY) {
        super(image.getArea().createTransformedArea(AffineTransform.getTranslateInstance(translationX, translationY)));
        this.translationX = translationX;
        this.translationY = translationY;
        this.image = image;
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.translate(this.translationX, this.translationY);
        this.image.draw(graphics);
        graphics.translate(-this.translationX, -this.translationY);
    }

    @Override
    Image translate(int x, int y) {
        return new ImageTranslate(this.image, this.translationX + x, this.translationY + y);
    }
}

