/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Functions;
import comp1110.universe.Image;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Line2D;

class Line
extends Image {
    final Image base;
    final int x1;
    final int y1;
    final int x2;
    final int y2;
    final Color color;
    final int thickness;

    Line(Image base, int x1, int y1, int x2, int y2, Color color, int thickness) {
        Area area = new Area(new Line2D.Double(x1, y1, x2, y2));
        super(base.area);
        this.base = base;
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
        this.thickness = thickness;
    }

    @Override
    void draw(Graphics2D graphics) {
        Shape clip = graphics.getClip();
        this.base.draw(graphics);
        Stroke orig = graphics.getStroke();
        graphics.setStroke(new BasicStroke(this.thickness));
        graphics.setClip(clip);
        graphics.setColor(this.color);
        graphics.drawLine(Functions.RoundInt((double)this.x1 + this.bounds.getX()), Functions.RoundInt((double)this.y1 + this.bounds.getY()), Functions.RoundInt((double)this.x2 + this.bounds.getX()), Functions.RoundInt((double)this.y2 + this.bounds.getY()));
        graphics.setStroke(orig);
    }
}

