/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Comp1110Exception;
import comp1110.lib.ConsList;
import comp1110.lib.Functions;
import comp1110.lib.Pair;
import comp1110.universe.Image;
import comp1110.universe.Mode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Area;

class Polygon
extends Image {
    java.awt.Polygon polygon;
    Color color;
    Mode mode;

    @SafeVarargs
    Polygon(Color color, Mode mode, Pair<Integer, Integer> ... coordinates) {
        int npoints = coordinates.length;
        if (npoints < 3) {
            throw new Comp1110Exception("Too few points to construct a polygon: " + npoints);
        }
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        for (int i = 0; i < npoints; ++i) {
            xpoints[i] = coordinates[i].first();
            ypoints[i] = coordinates[i].second();
        }
        java.awt.Polygon polygon = new java.awt.Polygon(xpoints, ypoints, npoints);
        super(new Area(polygon));
        this.polygon = polygon;
        this.color = color;
        this.mode = mode;
    }

    Polygon(Color color, Mode mode, ConsList<Pair<Integer, Integer>> coordinates) {
        int npoints = Functions.Length(coordinates);
        if (npoints < 3) {
            throw new Comp1110Exception("Too few points to construct a polygon: " + npoints);
        }
        int[] xpoints = new int[npoints];
        int[] ypoints = new int[npoints];
        int idx = 0;
        for (Pair pair : coordinates) {
            xpoints[idx] = (Integer)pair.first();
            ypoints[idx] = (Integer)pair.second();
            ++idx;
        }
        java.awt.Polygon polygon = new java.awt.Polygon(xpoints, ypoints, npoints);
        super(new Area(polygon));
        this.polygon = polygon;
        this.color = color;
        this.mode = mode;
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.setColor(this.color);
        switch (this.mode) {
            case SOLID: {
                graphics.fillPolygon(this.polygon);
                break;
            }
            case OUTLINE: {
                graphics.drawPolygon(this.polygon);
            }
        }
    }
}

