/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.universe.Image;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;

class RotatedImage
extends Image {
    final Image image;
    final double theta;

    RotatedImage(Image image, double theta) {
        while (theta > Math.PI * 2) {
            theta -= Math.PI * 2;
        }
        while (theta < Math.PI * -2) {
            theta += Math.PI * 2;
        }
        Area area = image.getArea().createTransformedArea(AffineTransform.getRotateInstance(theta, 0.0, 0.0));
        super(area);
        this.image = image;
        this.theta = theta;
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.rotate(this.theta);
        this.image.draw(graphics);
        graphics.rotate(-this.theta);
    }

    @Override
    Area getArea() {
        return this.area;
    }
}

