/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.universe.Image;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

class ScaledImage
extends Image {
    final double sx;
    final double sy;
    final Image image;

    ScaledImage(Image image, double sx, double sy) {
        super(image.getArea().createTransformedArea(AffineTransform.getScaleInstance(sx, sy)));
        this.image = image;
        this.sx = sx;
        this.sy = sy;
    }

    @Override
    void draw(Graphics2D graphics) {
        graphics.scale(this.sx, this.sy);
        this.image.draw(graphics);
        try {
            graphics.transform(AffineTransform.getScaleInstance(this.sx, this.sy).createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new RuntimeException(e);
        }
    }
}

