/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Comp1110Exception;
import comp1110.lib.Functions;
import comp1110.universe.FontStyle;
import comp1110.universe.ImageImage;
import comp1110.universe.TextAlign;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;

class Text
extends ImageImage {
    final String text;
    final int maxWidth;
    final Font font;

    private static float drawParagraph(Graphics2D graphics, String para, float maxWidth, Area area, TextAlign align, float drawPosY) {
        if (para.isEmpty()) {
            LineMetrics metrics = graphics.getFont().getLineMetrics(" ", graphics.getFontRenderContext());
            return drawPosY + metrics.getHeight();
        }
        AttributedString ats = new AttributedString(para);
        ats.addAttribute(TextAttribute.FONT, graphics.getFont());
        AttributedCharacterIterator paragraph = ats.getIterator();
        int paragraphStart = paragraph.getBeginIndex();
        int paragraphEnd = paragraph.getEndIndex();
        FontRenderContext frc = graphics.getFontRenderContext();
        LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, frc);
        lineMeasurer.setPosition(paragraphStart);
        while (lineMeasurer.getPosition() < paragraphEnd) {
            TextLayout layout = lineMeasurer.nextLayout(maxWidth);
            if (layout.getCharacterCount() == 0) {
                throw new Comp1110Exception("maxWidth is too small for characters in given String!");
            }
            float drawPosX = switch (align) {
                default -> throw new MatchException(null, null);
                case TextAlign.DEFAULT -> {
                    if (layout.isLeftToRight()) {
                        yield 0.0f;
                    }
                    yield maxWidth - layout.getAdvance();
                }
                case TextAlign.LEFT -> 0.0f;
                case TextAlign.RIGHT -> maxWidth - layout.getAdvance();
                case TextAlign.CENTER -> maxWidth / 2.0f - layout.getAdvance() / 2.0f;
                case TextAlign.JUSTIFY -> {
                    if (lineMeasurer.getPosition() < paragraphEnd) {
                        layout = layout.getJustifiedLayout(maxWidth);
                    }
                    yield 0.0f;
                }
            };
            layout.draw(graphics, drawPosX, drawPosY += layout.getAscent());
            area.add(new Area(layout.getBounds()).createTransformedArea(AffineTransform.getTranslateInstance(drawPosX, drawPosY)));
            drawPosY += layout.getDescent() + layout.getLeading();
        }
        return drawPosY;
    }

    Text(String text, int maxWidth, String fontName, FontStyle fontStyle, int fontSize, Color color, TextAlign align) {
        Font font = new Font(fontName, switch (fontStyle) {
            default -> throw new MatchException(null, null);
            case FontStyle.PLAIN -> 0;
            case FontStyle.ITALIC -> 2;
            case FontStyle.BOLD -> 1;
            case FontStyle.ITALICBOLD -> 3;
        }, fontSize);
        BufferedImage image = new BufferedImage(5, 5, 2);
        Graphics2D graphics = image.createGraphics();
        graphics.setFont(font);
        graphics.setColor(color);
        FontMetrics fm = graphics.getFontMetrics(font);
        String[] paragraphs = text.split("\n");
        Area area = new Area();
        if (maxWidth <= 0 && align == TextAlign.JUSTIFY) {
            throw new Comp1110Exception("Cannot justify text without a given maximum width!");
        }
        if (maxWidth >= 0) {
            float drawPosY = 0.0f;
            float maxWidthF = (float)maxWidth + 0.0f;
            for (String para : paragraphs) {
                drawPosY = Text.drawParagraph(graphics, para, maxWidth, area, align, drawPosY);
            }
            Rectangle bounds = area.getBounds();
            image = new BufferedImage(Functions.RoundInt(bounds.getWidth()), Functions.RoundInt(drawPosY), 2);
            graphics = image.createGraphics();
            graphics.setFont(font);
            graphics.setColor(color);
            drawPosY = 0.0f;
            for (String para : paragraphs) {
                drawPosY = Text.drawParagraph(graphics, para, maxWidth, area, align, drawPosY);
            }
        } else {
            float drawPosY = 0.0f;
            for (String para : paragraphs) {
                Rectangle2D lineBounds = fm.getStringBounds(para, graphics);
                LineMetrics metrics = fm.getLineMetrics(para, graphics);
                Area curArea = new Area(lineBounds);
                curArea.transform(AffineTransform.getTranslateInstance(0.0, drawPosY += metrics.getAscent()));
                area.add(curArea);
                drawPosY += metrics.getDescent() + metrics.getLeading();
            }
            Rectangle2D bounds = area.getBounds2D();
            image = new BufferedImage(Functions.RoundInt(bounds.getWidth()), Functions.RoundInt(bounds.getHeight()), 2);
            graphics = image.createGraphics();
            graphics.setFont(font);
            graphics.setColor(color);
            drawPosY = 0.0f;
            for (String para : paragraphs) {
                Rectangle2D lineBounds = fm.getStringBounds(para, graphics);
                LineMetrics metrics = fm.getLineMetrics(para, graphics);
                drawPosY += metrics.getAscent();
                float drawPosX = switch (align) {
                    default -> throw new MatchException(null, null);
                    case TextAlign.DEFAULT, TextAlign.LEFT -> 0.0f;
                    case TextAlign.RIGHT -> -((float)lineBounds.getWidth());
                    case TextAlign.CENTER -> (float)bounds.getWidth() / 2.0f - (float)lineBounds.getWidth() / 2.0f;
                    case TextAlign.JUSTIFY -> throw new Comp1110Exception("Cannot justify text without a given maximum width!");
                };
                graphics.drawString(para, drawPosX, drawPosY);
            }
        }
        super(image);
        this.maxWidth = maxWidth;
        this.font = font;
        this.text = text;
    }
}

