/*
 * Decompiled with CFR 0.152.
 */
package comp1110.universe;

import comp1110.lib.Functions;
import comp1110.universe.DrawFunction;
import comp1110.universe.Image;
import comp1110.universe.KeyEvent;
import comp1110.universe.KeyEventFunction;
import comp1110.universe.KeyEventKind;
import comp1110.universe.MouseEvent;
import comp1110.universe.MouseEventFunction;
import comp1110.universe.MouseEventKind;
import comp1110.universe.StepFunction;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Universe {
    private static Map<Integer, String> keyCodes = new HashMap<Integer, String>();

    private static String getKeyName(int key) {
        if (keyCodes.containsKey(key)) {
            return keyCodes.get(key);
        }
        return java.awt.event.KeyEvent.getKeyText(key);
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction) {
        new ConcreteUniverse<Object>(name, startState, state -> state, drawFunction, (state, kev) -> state, (state, mev) -> state, state -> false).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction) {
        new ConcreteUniverse<Object>(name, startState, stepFunction, drawFunction, (state, kev) -> state, (state, mev) -> state, state -> false).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, KeyEventFunction<State> keyFunction) {
        new ConcreteUniverse<Object>(name, startState, stepFunction, drawFunction, keyFunction, (state, mev) -> state, state -> false).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, MouseEventFunction<State> mouseFunction) {
        new ConcreteUniverse<Object>(name, startState, stepFunction, drawFunction, (state, kev) -> state, mouseFunction, state -> false).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, KeyEventFunction<State> keyFunction, MouseEventFunction<State> mouseFunction) {
        new ConcreteUniverse<Object>(name, startState, stepFunction, drawFunction, keyFunction, mouseFunction, state -> false).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, Predicate<State> endPredicate) {
        new ConcreteUniverse<State>(name, startState, state -> state, drawFunction, (state, kev) -> state, (state, mev) -> state, endPredicate).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, Predicate<State> endPredicate) {
        new ConcreteUniverse<State>(name, startState, stepFunction, drawFunction, (state, kev) -> state, (state, mev) -> state, endPredicate).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, KeyEventFunction<State> keyFunction, Predicate<State> endPredicate) {
        new ConcreteUniverse<State>(name, startState, stepFunction, drawFunction, keyFunction, (state, mev) -> state, endPredicate).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, MouseEventFunction<State> mouseFunction, Predicate<State> endPredicate) {
        new ConcreteUniverse<State>(name, startState, stepFunction, drawFunction, (state, kev) -> state, mouseFunction, endPredicate).waitForClosed();
    }

    public static <State> void BigBang(String name, State startState, DrawFunction<State> drawFunction, StepFunction<State> stepFunction, KeyEventFunction<State> keyFunction, MouseEventFunction<State> mouseFunction, Predicate<State> endPredicate) {
        new ConcreteUniverse<State>(name, startState, stepFunction, drawFunction, keyFunction, mouseFunction, endPredicate).waitForClosed();
    }

    static {
        keyCodes.put(48, "0");
        keyCodes.put(49, "1");
        keyCodes.put(50, "2");
        keyCodes.put(51, "3");
        keyCodes.put(52, "4");
        keyCodes.put(53, "5");
        keyCodes.put(54, "6");
        keyCodes.put(55, "7");
        keyCodes.put(56, "8");
        keyCodes.put(57, "9");
        keyCodes.put(65, "A");
        keyCodes.put(30, "Accept");
        keyCodes.put(107, "Add");
        keyCodes.put(65481, "Again");
        keyCodes.put(256, "All_candidates");
        keyCodes.put(240, "Alphanumeric");
        keyCodes.put(18, "Alt");
        keyCodes.put(65406, "Alt_graph");
        keyCodes.put(150, "Ampersand");
        keyCodes.put(151, "Asterisk");
        keyCodes.put(512, "At");
        keyCodes.put(66, "B");
        keyCodes.put(192, "Back_quote");
        keyCodes.put(92, "Back_slash");
        keyCodes.put(8, "Back_space");
        keyCodes.put(65368, "Begin");
        keyCodes.put(161, "Braceleft");
        keyCodes.put(162, "Braceright");
        keyCodes.put(67, "C");
        keyCodes.put(3, "Cancel");
        keyCodes.put(20, "Caps_lock");
        keyCodes.put(514, "Circumflex");
        keyCodes.put(12, "Clear");
        keyCodes.put(93, "Close_bracket");
        keyCodes.put(258, "Code_input");
        keyCodes.put(513, "Colon");
        keyCodes.put(44, "Comma");
        keyCodes.put(65312, "Compose");
        keyCodes.put(525, "Context_menu");
        keyCodes.put(17, "Control");
        keyCodes.put(28, "Convert");
        keyCodes.put(65485, "Copy");
        keyCodes.put(65489, "Cut");
        keyCodes.put(68, "D");
        keyCodes.put(134, "Dead_abovedot");
        keyCodes.put(136, "Dead_abovering");
        keyCodes.put(129, "Dead_acute");
        keyCodes.put(133, "Dead_breve");
        keyCodes.put(138, "Dead_caron");
        keyCodes.put(139, "Dead_cedilla");
        keyCodes.put(130, "Dead_circumflex");
        keyCodes.put(135, "Dead_diaeresis");
        keyCodes.put(137, "Dead_doubleacute");
        keyCodes.put(128, "Dead_grave");
        keyCodes.put(141, "Dead_iota");
        keyCodes.put(132, "Dead_macron");
        keyCodes.put(140, "Dead_ogonek");
        keyCodes.put(143, "Dead_semivoiced_sound");
        keyCodes.put(131, "Dead_tilde");
        keyCodes.put(142, "Dead_voiced_sound");
        keyCodes.put(110, "Decimal");
        keyCodes.put(127, "Delete");
        keyCodes.put(111, "Divide");
        keyCodes.put(515, "Dollar");
        keyCodes.put(40, "Down");
        keyCodes.put(69, "E");
        keyCodes.put(35, "End");
        keyCodes.put(10, "Enter");
        keyCodes.put(61, "Equals");
        keyCodes.put(27, "Escape");
        keyCodes.put(516, "Euro_sign");
        keyCodes.put(517, "Exclamation_mark");
        keyCodes.put(70, "F");
        keyCodes.put(112, "F1");
        keyCodes.put(121, "F10");
        keyCodes.put(122, "F11");
        keyCodes.put(123, "F12");
        keyCodes.put(61440, "F13");
        keyCodes.put(61441, "F14");
        keyCodes.put(61442, "F15");
        keyCodes.put(61443, "F16");
        keyCodes.put(61444, "F17");
        keyCodes.put(61445, "F18");
        keyCodes.put(61446, "F19");
        keyCodes.put(113, "F2");
        keyCodes.put(61447, "F20");
        keyCodes.put(61448, "F21");
        keyCodes.put(61449, "F22");
        keyCodes.put(61450, "F23");
        keyCodes.put(61451, "F24");
        keyCodes.put(114, "F3");
        keyCodes.put(115, "F4");
        keyCodes.put(116, "F5");
        keyCodes.put(117, "F6");
        keyCodes.put(118, "F7");
        keyCodes.put(119, "F8");
        keyCodes.put(120, "F9");
        keyCodes.put(24, "Final");
        keyCodes.put(65488, "Find");
        keyCodes.put(243, "Full_width");
        keyCodes.put(71, "G");
        keyCodes.put(160, "Greater");
        keyCodes.put(72, "H");
        keyCodes.put(244, "Half_width");
        keyCodes.put(156, "Help");
        keyCodes.put(242, "Hiragana");
        keyCodes.put(36, "Home");
        keyCodes.put(73, "I");
        keyCodes.put(263, "Input_method_on_off");
        keyCodes.put(155, "Insert");
        keyCodes.put(518, "Inverted_exclamation_mark");
        keyCodes.put(74, "J");
        keyCodes.put(260, "Japanese_hiragana");
        keyCodes.put(259, "Japanese_katakana");
        keyCodes.put(261, "Japanese_roman");
        keyCodes.put(75, "K");
        keyCodes.put(21, "Kana");
        keyCodes.put(262, "Kana_lock");
        keyCodes.put(25, "Kanji");
        keyCodes.put(241, "Katakana");
        keyCodes.put(225, "Kp_down");
        keyCodes.put(226, "Kp_left");
        keyCodes.put(227, "Kp_right");
        keyCodes.put(224, "Kp_up");
        keyCodes.put(76, "L");
        keyCodes.put(37, "Left");
        keyCodes.put(519, "Left_parenthesis");
        keyCodes.put(153, "Less");
        keyCodes.put(77, "M");
        keyCodes.put(157, "Meta");
        keyCodes.put(45, "Minus");
        keyCodes.put(31, "Modechange");
        keyCodes.put(106, "Multiply");
        keyCodes.put(78, "N");
        keyCodes.put(29, "Nonconvert");
        keyCodes.put(144, "Num_lock");
        keyCodes.put(520, "Number_sign");
        keyCodes.put(96, "Numpad0");
        keyCodes.put(97, "Numpad1");
        keyCodes.put(98, "Numpad2");
        keyCodes.put(99, "Numpad3");
        keyCodes.put(100, "Numpad4");
        keyCodes.put(101, "Numpad5");
        keyCodes.put(102, "Numpad6");
        keyCodes.put(103, "Numpad7");
        keyCodes.put(104, "Numpad8");
        keyCodes.put(105, "Numpad9");
        keyCodes.put(79, "O");
        keyCodes.put(91, "Open_bracket");
        keyCodes.put(80, "P");
        keyCodes.put(34, "Page_down");
        keyCodes.put(33, "Page_up");
        keyCodes.put(65487, "Paste");
        keyCodes.put(19, "Pause");
        keyCodes.put(46, "Period");
        keyCodes.put(521, "Plus");
        keyCodes.put(257, "Previous_candidate");
        keyCodes.put(154, "Printscreen");
        keyCodes.put(65482, "Props");
        keyCodes.put(81, "Q");
        keyCodes.put(222, "Quote");
        keyCodes.put(152, "Quotedbl");
        keyCodes.put(82, "R");
        keyCodes.put(39, "Right");
        keyCodes.put(522, "Right_parenthesis");
        keyCodes.put(245, "Roman_characters");
        keyCodes.put(83, "S");
        keyCodes.put(145, "Scroll_lock");
        keyCodes.put(59, "Semicolon");
        keyCodes.put(108, "Separator");
        keyCodes.put(16, "Shift");
        keyCodes.put(47, "Slash");
        keyCodes.put(32, "Space");
        keyCodes.put(65480, "Stop");
        keyCodes.put(109, "Subtract");
        keyCodes.put(84, "T");
        keyCodes.put(9, "Tab");
        keyCodes.put(85, "U");
        keyCodes.put(0, "Undefined");
        keyCodes.put(523, "Underscore");
        keyCodes.put(65483, "Undo");
        keyCodes.put(38, "Up");
        keyCodes.put(86, "V");
        keyCodes.put(87, "W");
        keyCodes.put(524, "Windows");
        keyCodes.put(88, "X");
        keyCodes.put(89, "Y");
        keyCodes.put(90, "Z");
    }

    private static class ConcreteUniverse<State>
    extends JPanel
    implements ActionListener,
    WindowListener,
    MouseListener,
    KeyListener,
    MouseMotionListener {
        private State state;
        private final double frameRate;
        private final long startTime = new Date().getTime();
        private double lastTick = 0.0;
        private final StepFunction<State> stepFunction;
        private final DrawFunction<State> drawFunction;
        private final KeyEventFunction<State> keyFunction;
        private final MouseEventFunction<State> mouseFunction;
        private final Predicate<State> endPredicate;
        private final JFrame frame;
        private final Timer timer;
        private Image currentImage;

        public ConcreteUniverse(String name, State startState, StepFunction<State> stepFunction, DrawFunction<State> drawFunction, KeyEventFunction<State> keyFunction, MouseEventFunction<State> mouseFunction, Predicate<State> endPredicate) {
            this(name, startState, stepFunction, drawFunction, keyFunction, mouseFunction, endPredicate, 30);
        }

        public ConcreteUniverse(String name, State startState, StepFunction<State> stepFunction, DrawFunction<State> drawFunction, KeyEventFunction<State> keyFunction, MouseEventFunction<State> mouseFunction, Predicate<State> endPredicate, int ticksPerSecond) {
            this.frame = new JFrame(name);
            this.frameRate = 1000.0 / (double)ticksPerSecond;
            this.state = startState;
            this.stepFunction = stepFunction;
            this.drawFunction = drawFunction;
            this.keyFunction = keyFunction;
            this.mouseFunction = mouseFunction;
            this.endPredicate = endPredicate;
            this.frame.addMouseMotionListener(this);
            this.currentImage = (Image)drawFunction.apply(startState);
            this.setSize(Functions.RoundInt(this.currentImage.bounds.getWidth()), Functions.RoundInt(this.currentImage.bounds.getHeight()));
            this.revalidate();
            this.frame.add(this);
            this.frame.pack();
            this.frame.setVisible(true);
            this.setVisible(true);
            this.repaint();
            this.frame.addKeyListener(this);
            this.timer = new Timer(10, this);
            this.timer.start();
            this.frame.addWindowListener(this);
            this.frame.requestFocus();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.frame.setDefaultCloseOperation(2);
        }

        public void stop() {
            this.timer.stop();
            this.frame.setVisible(false);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setClip(null);
            g.translate(-Functions.RoundInt(this.currentImage.bounds.getX()), -Functions.RoundInt(this.currentImage.bounds.getY()));
            g.clearRect(0, 0, this.frame.getWidth(), this.frame.getHeight());
            this.currentImage.draw((Graphics2D)g);
        }

        @Override
        public int getWidth() {
            return Functions.RoundInt(this.currentImage.bounds.getWidth());
        }

        @Override
        public int getHeight() {
            return Functions.RoundInt(this.currentImage.bounds.getHeight());
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getWidth(), this.getHeight());
        }

        @Override
        public boolean isValidateRoot() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double currentTick = (double)(new Date().getTime() - this.startTime) + 0.0;
            if (currentTick - this.lastTick >= this.frameRate) {
                this.lastTick += this.frameRate;
                this.state = this.stepFunction.apply(this.state);
                if (this.endPredicate.test(this.state)) {
                    this.stop();
                    return;
                }
                int oldWidth = Functions.RoundInt(this.currentImage.bounds.getWidth());
                int oldHeight = Functions.RoundInt(this.currentImage.bounds.getHeight());
                this.currentImage = (Image)this.drawFunction.apply(this.state);
                if (oldWidth != Functions.RoundInt(this.currentImage.bounds.getWidth()) || oldHeight != Functions.RoundInt(this.currentImage.bounds.getHeight())) {
                    this.frame.pack();
                    this.frame.revalidate();
                }
                this.repaint();
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.stop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowClosed(WindowEvent e) {
            ConcreteUniverse concreteUniverse = this;
            synchronized (concreteUniverse) {
                this.notify();
            }
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForClosed() {
            ConcreteUniverse concreteUniverse = this;
            synchronized (concreteUniverse) {
                while (this.frame.isVisible()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        @Override
        public void mouseClicked(java.awt.event.MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.LEFT_CLICK, e.getX(), e.getY()));
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.RIGHT_CLICK, e.getX(), e.getY()));
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MIDDLE_CLICK, e.getX(), e.getY()));
            }
        }

        @Override
        public void mousePressed(java.awt.event.MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.LEFT_BUTTON_DOWN, e.getX(), e.getY()));
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.RIGHT_BUTTON_DOWN, e.getX(), e.getY()));
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MIDDLE_BUTTON_DOWN, e.getX(), e.getY()));
            }
        }

        @Override
        public void mouseReleased(java.awt.event.MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.LEFT_BUTTON_UP, e.getX(), e.getY()));
            } else if (SwingUtilities.isRightMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.RIGHT_BUTTON_UP, e.getX(), e.getY()));
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MIDDLE_BUTTON_UP, e.getX(), e.getY()));
            }
        }

        @Override
        public void mouseEntered(java.awt.event.MouseEvent e) {
            this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MOUSE_ENTER, e.getX(), e.getY()));
        }

        @Override
        public void mouseExited(java.awt.event.MouseEvent e) {
            this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MOUSE_LEAVE, e.getX(), e.getY()));
        }

        @Override
        public void keyTyped(java.awt.event.KeyEvent e) {
            if (!Character.isISOControl(e.getKeyChar()) || e.getKeyChar() == '\n') {
                this.state = this.keyFunction.apply(this.state, new KeyEvent(KeyEventKind.KEY_TYPED, "" + e.getKeyChar()));
            }
        }

        @Override
        public void keyPressed(java.awt.event.KeyEvent e) {
            this.state = this.keyFunction.apply(this.state, new KeyEvent(KeyEventKind.KEY_PRESSED, Universe.getKeyName(e.getKeyCode())));
        }

        @Override
        public void keyReleased(java.awt.event.KeyEvent e) {
            this.state = this.keyFunction.apply(this.state, new KeyEvent(KeyEventKind.KEY_RELEASED, Universe.getKeyName(e.getKeyCode())));
        }

        @Override
        public void mouseDragged(java.awt.event.MouseEvent e) {
            this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MOUSE_MOVE, e.getX(), e.getY()));
        }

        @Override
        public void mouseMoved(java.awt.event.MouseEvent e) {
            this.state = this.mouseFunction.apply(this.state, new MouseEvent(MouseEventKind.MOUSE_MOVE, e.getX(), e.getY()));
        }
    }
}

